/**
 * Project Name:media-biz<br/>
 * File Name:AdsenseDAOImpl.java<br/>
 * Package Name:cn.com.duiba.tuia.media.dao.impl<br/>
 * Date:2016年9月26日下午7:26:58<br/>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.media.dao.impl;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Repository;

import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.api.dto.SlotDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqGetSlotsByPageDto;
import cn.com.duiba.tuia.media.dao.BaseDAO;
import cn.com.duiba.tuia.media.dao.SlotDAO;
import cn.com.duiba.tuia.media.model.IdAndName;
import cn.com.duiba.tuia.media.model.req.ReqSlotList;

/**
 * 广告位DAO实现类 <br/>
 * Date: 2016年9月26日 下午7:26:58 <br/>
 * 
 * @author ZFZ
 * @version
 * @since JDK 1.6
 * @see
 */

@Repository
public class SlotDAOImpl extends BaseDAO implements SlotDAO {

    @Override
    public int insert(SlotDto slotDto) throws TuiaMediaException {
        try {
            return getSqlSession().insert(getStamentNameSpace("insert"), slotDto);
        } catch (Exception e) {
            logger.error("SlotDAO.insert data happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public int update(SlotDto adsenseDto) throws TuiaMediaException {
        try {
            Date date = new Date();
            adsenseDto.setGmtModified(date);
            return getSqlSession().update(getStamentNameSpace("update"), adsenseDto);
        } catch (Exception e) {
            logger.error("SlotDAO.update data happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public List<SlotDto> selectListByPage(ReqSlotList param) throws TuiaMediaException {
        try {
            return getSqlSession().selectList(getStamentNameSpace("selectListByPage"), param);
        } catch (Exception e) {
            logger.error("SlotDAO.selectListByPage data happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public int selectAmountByPage(ReqSlotList param) throws TuiaMediaException {
        try {
            return getSqlSession().selectOne(getStamentNameSpace("selectAmountByPage"), param);
        } catch (Exception e) {
            logger.error("SlotDAO.selectAmountByPage data happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public int updateEnableStatus(Long slotId, int enableStatus) throws TuiaMediaException {
        try {
            Map<String, Object> param = new HashMap<>();
            param.put("slotId", slotId);
            param.put("enableStatus", enableStatus);
            return getSqlSession().update(getStamentNameSpace("updateEnableStatus"), param);
        } catch (Exception e) {
            logger.error("SlotDAO.updateEnableStatus data happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public SlotDto selectById(Long slotId) throws TuiaMediaException {
        try {
            return getSqlSession().selectOne(getStamentNameSpace("selectById"), slotId);
        } catch (Exception e) {
            logger.error("SlotDAO.selectById data happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public int updateCheckStatus(Long slotId, int checkStatus) throws TuiaMediaException {
        try {
            List<Long> slotIds = Collections.singletonList(slotId);
            return batchUpdateCheckStatus(slotIds, checkStatus);
        } catch (Exception e) {
            logger.error("SlotDAO.updateAdsenseCheckStatus data happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public int batchUpdateCheckStatus(List<Long> slotIds, int checkStatus) throws TuiaMediaException {
        if (CollectionUtils.isEmpty(slotIds)) {
            return 0;
        }

        try {
            Map<String, Object> param = new HashMap<>(2);
            param.put("slotIds", slotIds);
            param.put("checkStatus", checkStatus);
            return getSqlSession().update(getStamentNameSpace("batchUpdateCheckStatus"), param);
        } catch (Exception e) {
            logger.error("SlotDAO.batchUpdateCheckStatus data happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public int selectAdsenseAmountByPage(ReqGetSlotsByPageDto req, List<Long> appIdsList) throws TuiaMediaException {
        try {
            Map<String, Object> param = new HashMap<>(2);
            param.put("req", req);
            param.put("appIdsList", appIdsList);
            return getSqlSession().selectOne(getStamentNameSpace("selectAdsenseAmountByPage"), param);
        } catch (Exception e) {
            logger.error("SlotDAO.selectAdsenseAmountByPage data happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public List<SlotDto> selectListAdsenseByPage(ReqGetSlotsByPageDto req, List<Long> appIdsList) throws TuiaMediaException {
        try {
            Map<String, Object> param = new HashMap<>(2);
            param.put("req", req);
            param.put("appIdsList", appIdsList);
            return getSqlSession().selectList(getStamentNameSpace("selectListAdsenseByPage"), param);
        } catch (Exception e) {
            logger.error("SlotDAO.selectAdsenseListByPage data happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public List<SlotDto> selectListDetail(List<Long> slotIds) throws TuiaMediaException {
        if (CollectionUtils.isEmpty(slotIds)) {
            return Collections.emptyList();
        }
        try {
            return getSqlSession().selectList(getStamentNameSpace("selectListDetail"), slotIds);
        } catch (Exception e) {
            logger.error("SlotDAO.getListDetail data happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public List<Long> selectIdsByName(String slotName) throws TuiaMediaException {
        try {
            return getSqlSession().selectList(getStamentNameSpace("selectIdsByName"), slotName);
        } catch (Exception e) {
            logger.error("SlotDAO.selectIdsByName data happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public List<IdAndName> selectAppIdAndName(List<Long> slotIds) throws TuiaMediaException {
        try {
            return getSqlSession().selectList(getStamentNameSpace("selectAppIdAndName"), slotIds);
        } catch (Exception e) {
            logger.error("SlotDAO.selectAppIdAndName data happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public int batchUpdateEnableStatus(List<Long> slotIds, int enableStatus) throws TuiaMediaException {
        if (CollectionUtils.isEmpty(slotIds)) {
            return 0;
        }
        try {
            Map<String, Object> param = new HashMap<>(2);
            param.put("slotIds", slotIds);
            param.put("enableStatus", enableStatus);
            return getSqlSession().update(getStamentNameSpace("batchUpdateEnableStatus"), param);
        } catch (Exception e) {
            logger.error("SlotDAO.batchUpdateEnableStatus data happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public List<IdAndName> selectAllSlotIdAndName() throws TuiaMediaException {
        try {
            return getSqlSession().selectList(getStamentNameSpace("selectAllSlotIdAndName"));
        } catch (Exception e) {
            logger.error("SlotDAO.selectAllSlotIdAndName data happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public int closeSlotByMsId(Long msId) throws TuiaMediaException {
        try {
            return getSqlSession().update(getStamentNameSpace("closeSlotByMsId"), msId);
        } catch (Exception e) {
            logger.error("SlotDAO.closeSlotByMsId data happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public List<Long> getIdsByMsId(Long msId) throws TuiaMediaException {
        try {
            return getSqlSession().selectList(getStamentNameSpace("getIdsByMsId"), msId);
        } catch (Exception e) {
            logger.error("SlotDAO.getIdsByMsId data happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public int updateDelStatus(Long slotId, Long mediaId) throws TuiaMediaException {
        try {
            HashMap<String, Object> map = new HashMap<>();
            map.put("slotId", slotId);
            map.put("mediaId", mediaId);
            return getSqlSession().update(getStamentNameSpace("updateDelStatus"), map);
        } catch (Exception e) {
            logger.error("SlotDAO.updateDelStatus data happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }
}
