/**
 * Project Name:media-biz<br>
 * File Name:AccountCheckRecordDto.java<br>
 * Package Name:cn.com.duiba.tuia.media.domain<br>
 * Date:2016年9月26日下午3:18:39<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.media.domain;

import org.apache.commons.lang.builder.ToStringBuilder;

import cn.com.duiba.tuia.media.api.dto.BaseDto;

/**
 * ClassName: AccountCheckRecordDto <br/>
 * date: 2016年9月26日 下午3:18:39 <br/>
 *
 * @author xiawei
 * @version
 * @since JDK 1.6
 */
public class AccountCheckRecordDto extends BaseDto {

    private static final long serialVersionUID = 1L;

    /** 审核通过 */
    public static final int   CHECK_PASS       = 0;
    /** 审核不通过 */
    public static final int   CHECK_REFUSE     = 1;
    /** 冻结 */
    public static final int   FREEZE           = 2;
    /** 解冻 */
    public static final int   UNFREEZE         = 3;

    /** 审核的账号id */
    private long              mediaId;
    /** 审核动作类型,0-审核通过;1-审核拒绝;2-冻结;3-解冻 */
    private int               checkType;
    /** 拒绝或冻结理由 */
    private String            reason;

    /**
     * mediaId.
     *
     * @return the mediaId
     * @since JDK 1.6
     */
    public long getMediaId() {
        return mediaId;
    }

    /**
     * mediaId.
     *
     * @param mediaId the mediaId to set
     * @since JDK 1.6
     */
    public void setMediaId(long mediaId) {
        this.mediaId = mediaId;
    }

    public int getCheckType() {
        return checkType;
    }

    public void setCheckType(int checkType) {
        this.checkType = checkType;
    }

    public String getReason() {
        return reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
