/**
 * Project Name:media-biz<br>
 * File Name:ReqSendEmail.java<br>
 * Package Name:cn.com.duiba.tuia.media.model.req<br>
 * Date:2016年10月12日上午11:35:56<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.media.model.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.hibernate.validator.constraints.Email;
import org.hibernate.validator.constraints.NotBlank;

/**
 * ClassName: ReqSendEmail <br/>
 * Function: 发生邮件请求参数. <br/>
 * date: 2016年10月12日 上午11:35:56 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
@ApiModel
public class ReqSendEmail {

    /** 邮箱. */
    @ApiModelProperty(value = "邮箱", required = true)
    @Email(message = "邮箱格式错误")
    @NotBlank(message = "邮箱不能为空")
    private String email;

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
