/**
 * Project Name:media-biz<br>
 * File ReqUpdateAccountBase.java<br>
 * Package Name:cn.com.duiba.tuia.media.model.req<br>
 * Date:2016年9月28日上午11:31:46<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.media.model.req;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * ClassName: ReqUpdateAccountBase <br/>
 * date: 2016年9月28日 上午11:31:46 <br/>
 *
 * @author xiawei
 * @version
 * @since JDK 1.6
 */
@ApiModel
public class ReqUpdateAccountBase {

    /** 媒体账户ID. */
    @ApiModelProperty(value = "媒体账户ID", required = false)
    private Long   mediaId;

    /** 联系人姓名. */
    @ApiModelProperty(value = "联系人姓名", required = false)
    @NotBlank(message = "联系人姓名不可为空")
    @Length(min = 2, max = 20, message = "联系人姓名为2-20个字符")
    private String linkman;

    /** 联系人手机号. */
    @ApiModelProperty(value = "联系人手机号", required = false)
    @NotBlank(message = "联系人手机号不可为空")
    @Length(min = 11, max = 11, message = "手机号必须是11位")
    private String linkPhone;

    /** 邮箱账号. */
    @ApiModelProperty(value = "邮箱账号", required = false)
    private String email;

    /**
     * mediaId.
     *
     * @return the mediaId
     * @since JDK 1.6
     */
    public Long getMediaId() {
        return mediaId;
    }

    /**
     * mediaId.
     *
     * @param mediaId the mediaId to set
     * @since JDK 1.6
     */
    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    /**
     * linkman.
     *
     * @return the linkman
     * @since JDK 1.6
     */
    public String getLinkman() {
        return linkman;
    }

    /**
     * linkman.
     *
     * @param linkman the linkman to set
     * @since JDK 1.6
     */
    public void setLinkman(String linkman) {
        this.linkman = linkman;
    }

    /**
     * linkPhone.
     *
     * @return the linkPhone
     * @since JDK 1.6
     */
    public String getLinkPhone() {
        return linkPhone;
    }

    /**
     * linkPhone.
     *
     * @param linkPhone the linkPhone to set
     * @since JDK 1.6
     */
    public void setLinkPhone(String linkPhone) {
        this.linkPhone = linkPhone;
    }

    /**
     * email.
     *
     * @return the email
     * @since JDK 1.6
     */
    public String getEmail() {
        return email;
    }

    /**
     * email.
     *
     * @param email the email to set
     * @since JDK 1.6
     */
    public void setEmail(String email) {
        this.email = email;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
