/**
 * Project Name:media-biz<br>
 * File Name:ReqVerifySMS.java<br>
 * Package Name:cn.com.duiba.tuia.media.model.req<br>
 * Date:2016年9月26日下午5:41:11<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.media.model.req;

import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

import org.apache.commons.lang3.builder.ToStringBuilder;

/**
 * ClassName: ReqVerifySMS <br/>
 * Function: 校验短信验证码请求参数. <br/>
 * date: 2016年9月26日 下午5:41:11 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
public class ReqVerifySMS {

    /** 手机号. */
    @ApiModelProperty(value = "手机号", required = false)
    @NotNull(message = "手机号不能为空")
    private String  phone;

    /** 验证码类型. */
    @ApiModelProperty(value = "验证码类型", required = false)
    @NotNull(message = "验证码类型不能为空")
    private Integer type;

    /** 验证码. */
    @ApiModelProperty(value = "验证码", required = false)
    @NotNull(message = "验证码不能为空")
    private String  code;

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
