package cn.com.duiba.tuia.media.parser;

import java.util.ArrayList;
import java.util.List;

import org.springframework.util.StringUtils;

import cn.com.duiba.tuia.media.api.dto.rsp.RspActivityDto;
import cn.com.duiba.tuia.media.api.constant.ActivityStatusConstant;
import cn.com.duiba.tuia.media.api.constant.ActivityTypeConstant;
import cn.com.duiba.tuia.media.domain.ActivityDto;

/**
 * @author xuyenan
 * @createTime 2016/12/22
 */
public final class ActivityDtoParser {

    private ActivityDtoParser() {
    }

    /**
     * ActivityDto parse to RspActivityDto，部分字段需在转换后自己赋值
     * 
     * @param activityDto
     * @return RspActivityDto
     */
    public static RspActivityDto parseToRspActivityDto(ActivityDto activityDto) {
        RspActivityDto rspActivityDto = new RspActivityDto();
        rspActivityDto.setId(activityDto.getActivityId());
        rspActivityDto.setName(activityDto.getActivityName());
        rspActivityDto.setType(activityDto.getActivityType());
        rspActivityDto.setTypeName(ActivityTypeConstant.getTypeText(activityDto.getActivityType()));
        rspActivityDto.setStatus(ActivityStatusConstant.getStatusText(activityDto.getActivityStatus()));
        rspActivityDto.setDirectAdvertMode(activityDto.getDirectAdvertMode());
        rspActivityDto.setIsDirectAdvert(activityDto.getIsDirectAdvert());
        rspActivityDto.setIsDirectMedia(activityDto.getIsDirectMedia());
        rspActivityDto.setIsEnable(activityDto.getIsEnable());
        rspActivityDto.setIsPublish(activityDto.getIsPublish());
        rspActivityDto.setPlanId(activityDto.getId());
        if (!StringUtils.isEmpty(activityDto.getActivityMsList())) {
            List<Long> msIdList = new ArrayList<>();
            for (String msIdStr : activityDto.getActivityMsList().split(",")) {
                msIdList.add(Long.valueOf(msIdStr));
            }
            rspActivityDto.setMsIdList(msIdList);
        }
        return rspActivityDto;
    }
}
