/**
 * Project Name:media-biz<br/>
 * File Name:RemoteAccountChangeBackendServiceImpl.java<br/>
 * Package Name:cn.com.duiba.tuia.media.remoteservice<br/>
 * Date:2016年12月6日下午8:45:17<br/>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.media.remoteservice;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;

import cn.com.duiba.tuia.media.api.dto.AccountChangeDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqAccountChange;
import cn.com.duiba.tuia.media.api.dto.rsp.AccountChangeRsp;
import cn.com.duiba.tuia.media.api.dto.rsp.RspAccountChangeResult;
import cn.com.duiba.tuia.media.api.remoteservice.RemoteAccountChangeBackendService;
import cn.com.duiba.tuia.media.dao.AccountChangeDAO;
import cn.com.duiba.tuia.media.service.AccountChangeService;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemoteAccountChangeBackendServiceImpl <br/>
 * Date: 2016年12月6日 下午8:45:17 <br/>
 * 
 * @author ZFZ
 * @version
 * @since JDK 1.6
 * @see
 */
public class RemoteAccountChangeBackendServiceImpl extends BaseRemoteService implements RemoteAccountChangeBackendService {

    @Autowired
    private AccountChangeService accountChangeService;

    @Autowired
    private AccountChangeDAO     accountChangeDAO;

    @Override
    public DubboResult<Boolean> addAccountChange(AccountChangeDto accountChangeDto) {
        try {
            accountChangeService.insertAccountChange(accountChangeDto);
            return DubboResult.successResult(true);
        } catch (Exception e) {
            logger.error("RemoteAccountChangeBackendServiceImpl.addAccountChange is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<RspAccountChangeResult<AccountChangeRsp>> selectAccountChangeByPage(ReqAccountChange req) {
        try {
            return DubboResult.successResult(accountChangeService.selectAccountChangeByPage(req));
        } catch (Exception e) {
            logger.error("RemoteAccountChangeBackendServiceImpl.selectAccountChangeList is error", e);
            return exceptionFailure(e);
        }
    }


    @Override
    public DubboResult<AccountChangeDto> selectAccountChangeById(Long id) {
        try {
            return DubboResult.successResult(accountChangeService.selectAccountChangeById(id));
        } catch (Exception e) {
            logger.error("RemoteAccountChangeBackendServiceImpl.selectAccountChangeById is error", e);
            return exceptionFailure(e);
        }

    }

    @Override
    public DubboResult<AccountChangeDto> selectAccountChangeByMediaId(Long mediaId) {
        try {
            return DubboResult.successResult(accountChangeService.selectAccountChangeByMediaId(mediaId));
        } catch (Exception e) {
            logger.error("RemoteAccountChangeBackendServiceImpl.selectAccountChangeByMediaId is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<List<AccountChangeDto>> selectAccountChangeList(ReqAccountChange req) {
        try {
            return DubboResult.successResult(accountChangeService.selectAccountChangeList(req));
        } catch (Exception e) {
            logger.error("RemoteAccountChangeBackendServiceImpl.selectAccountChangeByMediaId is error", e);
            return exceptionFailure(e);
        }
    }
}
