package cn.com.duiba.tuia.media.remoteservice;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import cn.com.duiba.tuia.media.api.dto.MediaAppDto;
import cn.com.duiba.tuia.media.api.dto.PageResultDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqActivityDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqIdAndType;
import cn.com.duiba.tuia.media.api.dto.rsp.RspActivityAdvertDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspActivityDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspMaterialSpecificationDto;
import cn.com.duiba.tuia.media.api.remoteservice.RemoteActivityBackendService;
import cn.com.duiba.tuia.media.model.IdAndName;
import cn.com.duiba.tuia.media.parser.IdAndNameParser;
import cn.com.duiba.tuia.media.service.*;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * @author xuyenan
 * @createTime 2016/10/25
 */
public class RemoteActivityBackendServiceImpl extends BaseRemoteService implements RemoteActivityBackendService {

    @Autowired
    private ActivityService         activityService;

    @Autowired
    private MediaAppActivityService mediaAppActivityService;

    @Autowired
    private ActivityAdvertService   activityAdvertService;

    @Autowired
    private MediaAppService         mediaAppService;

    @Autowired
    private AdvertService           advertService;

    @Override
    public DubboResult<List<RspActivityDto>> getByActivityIds(List<Long> activityIds) {
        try {
            List<RspActivityDto> rspActivityDtoList = activityService.getActivityByIds(activityIds);
            return DubboResult.successResult(rspActivityDtoList);
        } catch (Exception e) {
            logger.error("RemoteActivityBackendService.getByActivityIds is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<String> getActivityNameByIdAndType(Long id, Integer type) {
        try {
            String name = activityService.getActivityName(id, type);
            return DubboResult.successResult(name);
        } catch (Exception e) {
            logger.error("RemoteActivityBackendService.getActivityByIdAndType is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<PageResultDto<RspActivityDto>> getPlanList(ReqActivityDto req) {
        try {
            return DubboResult.successResult(new PageResultDto<>(activityService.getPlanListAmount(req), activityService.getPlanList(req), req.getPageSize()));
        } catch (Exception e) {
            logger.error("RemoteActivityBackendService.getPlanList is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<Boolean> addActivityPlan(List<ReqIdAndType> activities) {
        try {
            return DubboResult.successResult(activityService.addActivityPlan(activities));
        } catch (Exception e) {
            logger.error("RemoteActivityBackendService.addActivityPlan is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<Boolean> deleteActivityPlan(Long activityId, Integer activityType) {
        try {
            return DubboResult.successResult(activityService.deleteActivityPlan(activityId, activityType));
        } catch (Exception e) {
            logger.error("RemoteActivityBackendService.deleteActivityPlan is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<Boolean> changeActivityPlanEnable(Long activityId, Integer activityType, Integer enableStatus) {
        try {
            return DubboResult.successResult(activityService.changeActivityPlanEnable(activityId, activityType, enableStatus));
        } catch (Exception e) {
            logger.error("RemoteActivityBackendService.changeActivityPlanEnable is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<Boolean> updateActivityPlan(ReqActivityDto reqActivityDto) {
        try {
            return DubboResult.successResult(activityService.updateActivityPlan(reqActivityDto));
        } catch (Exception e) {
            logger.error("RemoteActivityBackendService.updateActivityPlan is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<RspActivityDto> getActivityPlanDetail(Long activityId, Integer activityType) {
        try {
            RspActivityDto rspActivityDto = activityService.getActivityPlanDetail(activityId, activityType);
            // 查询素材列表
            rspActivityDto = activityService.getMsItemContent(rspActivityDto);
            return DubboResult.successResult(rspActivityDto);
        } catch (Exception e) {
            logger.error("RemoteActivityBackendService.getActivityPlanDetail is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<List<MediaAppDto>> getActivityDirectedMediaApp(Long activityId, Integer activityType) {
        try {
            List<Long> list = mediaAppActivityService.getActivityDirectedMediaApp(activityId, activityType);
            List<MediaAppDto> result = new ArrayList<>();
            if (!CollectionUtils.isEmpty(list)) {
                List<IdAndName> apps = mediaAppService.selectAppIdAndName(list);
                for (IdAndName idAndName : apps) {
                    result.add(IdAndNameParser.parseToMediaAppDto(idAndName));
                }
            }
            return DubboResult.successResult(result);
        } catch (Exception e) {
            logger.error("RemoteActivityBackendService.activityDirectToMediaApp is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<Boolean> activityDirectToMediaApp(Long activityId, Integer activityType, Integer directStatus, List<Long> appIds) {
        try {
            return DubboResult.successResult(mediaAppActivityService.activityDirectToMediaApp(activityId, activityType, directStatus, appIds));
        } catch (Exception e) {
            logger.error("RemoteActivityBackendService.activityDirectToMediaApp is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<List<RspActivityAdvertDto>> getActivityDirectedAdvert(Long activityId, Integer activityType) {
        try {
            List<Long> list = activityAdvertService.getActivityAdvertIds(activityId, activityType);
            return DubboResult.successResult(advertService.getAdvertsByIds(list));
        } catch (Exception e) {
            logger.error("RemoteActivityBackendService.getActivityDirectedAdvert is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<Boolean> activityDirectToAdvert(Long activityId, Integer activityType, Integer directStatus, Integer directMode, List<Long> advertIds) {
        try {
            return DubboResult.successResult(activityAdvertService.activityDirectToAdvert(activityId, activityType, directStatus, directMode, advertIds));
        } catch (Exception e) {
            logger.error("RemoteActivityBackendService.activityDirectToAdvert is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<List<RspMaterialSpecificationDto>> getMsItemList() {
        try {
            return DubboResult.successResult(activityService.getMsItemList());
        } catch (Exception e) {
            logger.error("RemoteActivityBackendService.getMsItemList is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<List<RspActivityAdvertDto>> getAdvertByIds(List<Long> ids) {
        try {
            return DubboResult.successResult(advertService.getAdvertsByIds(ids));
        } catch (Exception e) {
            logger.error("RemoteActivityBackendService.getMsItemList is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<RspActivityDto> getActivityPlan(Long activityId, Integer activityType) {
        try {
            return DubboResult.successResult(activityService.getActivityPlanDetail(activityId, activityType));
        } catch (Exception e) {
            logger.error("RemoteActivityBackendService.getActivityPlan is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<List<Long>> getActivityAdvertIds(Long activityId, Integer activityType) {
        try {
            return DubboResult.successResult(activityAdvertService.getActivityAdvertIds(activityId, activityType));
        } catch (Exception e) {
            logger.error("RemoteActivityBackendService.getActivityAdvertIds is error", e);
            return exceptionFailure(e);
        }
    }
}
