package cn.com.duiba.tuia.media.remoteservice;

import java.util.List;

import cn.com.duiba.tuia.media.dataobject.ActivitySlotDO;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

import cn.com.duiba.tuia.media.api.dto.PageResultDto;
import cn.com.duiba.tuia.media.api.dto.SlotDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqActivitySlotDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspActivitySlotDto;
import cn.com.duiba.tuia.media.api.remoteservice.RemoteActivitySlotBackendService;
import cn.com.duiba.tuia.media.service.ActivitySlotService;
import cn.com.duiba.tuia.media.service.SlotService;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * @author xuyenan
 * @createTime 2016/12/26
 */
public class RemoteActivitySlotBackendServiceImpl extends BaseRemoteService implements RemoteActivitySlotBackendService {

    @Autowired
    private ActivitySlotService activitySlotService;

    @Autowired
    private SlotService         slotService;

    @Override
    public DubboResult<Boolean> addSlots(List<Long> slotIds) {
        try {
            return DubboResult.successResult(activitySlotService.addSlots(slotIds));
        } catch (Exception e) {
            logger.error("RemoteActivitySlotBackendService.addSlots is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<Boolean> deleteSlot(Long slotId) {
        try {
            return DubboResult.successResult(activitySlotService.deleteSlot(slotId));
        } catch (Exception e) {
            logger.error("RemoteActivitySlotBackendService.deleteSlot is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<PageResultDto<RspActivitySlotDto>> getList(ReqActivitySlotDto req) {
        try {
            return DubboResult.successResult(new PageResultDto<>(activitySlotService.getListAmount(req),
                                                                 activitySlotService.getList(req), req.getPageSize()));
        } catch (Exception e) {
            logger.error("RemoteActivitySlotBackendService.getList is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<List<SlotDto>> getSlotByIds(List<Long> ids) {
        try {
            return DubboResult.successResult(slotService.getListDetail(ids));
        } catch (Exception e) {
            logger.error("RemoteActivitySlotBackendService.getSlotByIds is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<RspActivitySlotDto> getById(Long slotId) {
        try {
            ActivitySlotDO activitySlotDO = activitySlotService.getBySlotId(slotId);
            RspActivitySlotDto rspActivitySlotDto = new RspActivitySlotDto();
            if (activitySlotDO != null) {
                BeanUtils.copyProperties(activitySlotDO, rspActivitySlotDto);
            }
            return DubboResult.successResult(rspActivitySlotDto);
        } catch (Exception e) {
            logger.error("RemoteActivitySlotBackendService.getBySlotId is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<Boolean> updateDirectMode(Long slotId, Integer directMode) {
        try {
            return DubboResult.successResult(activitySlotService.updateDirectMode(slotId, directMode));
        } catch (Exception e) {
            logger.error("RemoteActivitySlotBackendService.updateDirectMode is error", e);
            return exceptionFailure(e);
        }
    }
}
