package cn.com.duiba.tuia.media.remoteservice;

import java.util.ArrayList;
import java.util.List;

import cn.com.duiba.tuia.media.domain.ActivitySortDto;
import cn.com.duiba.tuia.media.service.ActivityService;
import org.springframework.beans.factory.annotation.Autowired;

import cn.com.duiba.tuia.media.api.dto.PageResultDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqActivitySort;
import cn.com.duiba.tuia.media.api.dto.req.ReqIdAndType;
import cn.com.duiba.tuia.media.api.dto.rsp.RspActivityDto;
import cn.com.duiba.tuia.media.api.remoteservice.RemoteActivitySortBackendService;
import cn.com.duiba.tuia.media.service.ActivitySortService;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * @author xuyenan
 * @createTime 2016/10/25
 */
public class RemoteActivitySortBackendServiceImpl extends BaseRemoteService implements RemoteActivitySortBackendService {

    @Autowired
    private ActivityService     activityService;
    @Autowired
    private ActivitySortService activitySortService;

    @Override
    public DubboResult<PageResultDto<RspActivityDto>> getByCondition(ReqActivitySort reqActivitySort) {
        try {
            int amount = activitySortService.selectByConditionAmount(reqActivitySort);
            reqActivitySort.setSort("activity_sort asc,gmt_modified desc");
            reqActivitySort.setRowStart(reqActivitySort.getPageSize() * (reqActivitySort.getCurrentPage() - 1));
            List<ActivitySortDto> result = activitySortService.selectByCondition(reqActivitySort);
            List<RspActivityDto> list = new ArrayList<>();
            for (ActivitySortDto activitySortDto : result) {
                list.add(activityService.getActivityPlanDetail(activitySortDto.getActivityId(), activitySortDto.getActivityType()));
            }
            return DubboResult.successResult(new PageResultDto<>(amount, list, reqActivitySort.getPageSize()));
        } catch (Exception e) {
            logger.error("RemoteActivitySortBackendService.getByCondition is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<Boolean> addActivitySort(Long slotId, List<ReqIdAndType> idAndTypes) {
        try {
            DubboResult<Boolean> result = new DubboResult<>();
            result.setSuccess(true);
            result.setReturnCode("0");
            int successRecord = activitySortService.addActivitySort(slotId, idAndTypes);
            result.setMsg("成功添加" + successRecord + "个活动");
            return result;
        } catch (Exception e) {
            logger.error("RemoteActivitySortBackendService.addActivitySort is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<Boolean> addDefaultActivitySort(Long slotId) {
        try {
            DubboResult<Boolean> result = new DubboResult<>();
            result.setSuccess(true);
            result.setReturnCode("0");
            int successRecord = activitySortService.addDefaultActivitySort(slotId);
            result.setMsg("成功添加" + successRecord + "个活动");
            return result;
        } catch (Exception e) {
            logger.error("RemoteActivitySortBackendService.addDefaultActivitySort is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<Boolean> removeActivity(Long slotId, Long activityId, Integer activityType) {
        try {
            return DubboResult.successResult(activitySortService.deleteActivity(activityId, activityType, slotId));
        } catch (Exception e) {
            logger.error("RemoteActivitySortBackendService.removeActivity is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<Boolean> sort(Long slotId, Long activityId, Integer activityType, int location) {
        try {
            return DubboResult.successResult(activitySortService.sortActivity(slotId, activityId, activityType, location));
        } catch (Exception e) {
            logger.error("RemoteActivitySortBackendService.sort is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<List<RspActivityDto>> getActivityByApp(Long appId) {
        try {
            return DubboResult.successResult(activitySortService.getActivityForRecommendByApp(appId));
        } catch (Exception e) {
            logger.error("RemoteActivitySortBackendService.getActivityByApp is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<List<RspActivityDto>> getActivityBySlot(Long slotId) {
        try {
            return DubboResult.successResult(activitySortService.getActivityForRecommendBySlot(slotId));
        } catch (Exception e) {
            logger.error("RemoteActivitySortBackendService.getActivityBySlot is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<List<RspActivityDto>> getActivityForCenter(Long slotId) {
        try {
            return DubboResult.successResult(activitySortService.getActivityForCenter(0L));
        } catch (Exception e) {
            logger.error("RemoteActivitySortBackendService.getActivityBySlot is error", e);
            return exceptionFailure(e);
        }
    }
}
