/**
 * Project Name:media-biz File Name:RemoteMediaAppService.java Package Name:cn.com.duiba.tuia.media.remoteservice
 * Date:2016年9月30日下午4:02:06 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.media.remoteservice;

import java.util.List;

import cn.com.duiba.tuia.media.model.IdAndName;
import cn.com.duiba.tuia.media.parser.IdAndNameParser;
import org.springframework.beans.factory.annotation.Autowired;

import cn.com.duiba.tuia.media.api.dto.MediaAppDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqUpdateMediaAppStatusDto;
import cn.com.duiba.tuia.media.api.remoteservice.RemoteMediaAppBackendService;
import cn.com.duiba.tuia.media.service.MediaAppService;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.ArrayList;

/**
 * ClassName:RemoteMediaAppService <br/>
 * Function: tuia媒体app信息服务. <br/>
 * Date: 2016年9月30日 下午4:02:06 <br/>
 * 
 * @author Administrator
 * @version
 * @since JDK 1.6
 * @see
 */
public class RemoteMediaAppBackendServiceImpl extends BaseRemoteService implements RemoteMediaAppBackendService {

    @Autowired
    MediaAppService mediaAppService;

    @Override
    public DubboResult<Boolean> updateMediaAppStatus(ReqUpdateMediaAppStatusDto param) {
        try {
            return DubboResult.successResult(this.mediaAppService.updateMediaAppStatus(param));
        } catch (Exception e) {
            logger.error("RemoteMediaAppBackendServiceImpl.updateMediaAppStatus is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<MediaAppDto> getMediaApp(Long appId) {
        try {
            return DubboResult.successResult(this.mediaAppService.getMediaAppDto(appId));
        } catch (Exception e) {
            logger.error("RemoteMediaAppBackendServiceImpl.getMediaApp is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<Boolean> getAllAppIdAndName() {
        try {
            return DubboResult.successResult(this.mediaAppService.selectAllAppIdAndName());
        } catch (Exception e) {
            logger.error("RemoteMediaAppBackendServiceImpl.setAllAppIdAndName is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<Boolean> delAllAppIdAndName() {
        try {
            return DubboResult.successResult(this.mediaAppService.delAllAppIdAndName());
        } catch (Exception e) {
            logger.error("RemoteMediaAppBackendServiceImpl.delAllAppIdAndName is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<List<Long>> getAppIdsByName(String name) {
        try {
            return DubboResult.successResult(this.mediaAppService.selectIdsByName(name));
        } catch (Exception e) {
            logger.error("RemoteMediaAppBackendServiceImpl.getAppIdsByName is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<String> getAppNameById(Long appId) {
        try {
            return DubboResult.successResult(this.mediaAppService.selectAppNameById(appId));
        } catch (Exception e) {
            logger.error("RemoteMediaAppBackendServiceImpl.getAppNameById is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<List<MediaAppDto>> getMediaAppByIds(List<Long> ids) {
        try {
            List<IdAndName> list = mediaAppService.selectAppIdAndName(ids);
            List<MediaAppDto> result = new ArrayList<>();
            for (IdAndName idAndName : list) {
                result.add(IdAndNameParser.parseToMediaAppDto(idAndName));
            }
            return DubboResult.successResult(result);
        } catch (Exception e) {
            logger.error("RemoteMediaAppBackendServiceImpl.getMediaApp is error", e);
            return exceptionFailure(e);
        }
    }
}
