/**
 * Project Name:media-biz<br/>
 * File Name:AccountChangeService.java<br/>
 * Package Name:cn.com.duiba.tuia.media.service<br/>
 * Date:2016年12月6日下午8:39:53<br/>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.media.service;

import java.io.OutputStream;
import java.util.List;

import cn.com.duiba.tuia.media.api.dto.AccountChangeDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqAccountChange;
import cn.com.duiba.tuia.media.api.dto.rsp.AccountChangeRsp;
import cn.com.duiba.tuia.media.api.dto.rsp.RspAccountChangeResult;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;

/**
 * ClassName:AccountChangeService <br/>
 * Date: 2016年12月6日 下午8:39:53 <br/>
 * 
 * @author ZFZ
 * @version
 * @since JDK 1.6
 * @see
 */
public interface AccountChangeService {

    /**
     * selectAccountChangeList:(分页查询媒体账户月资金流水记录). <br/>
     *
     * @author ZFZ
     * @param req
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    RspAccountChangeResult<AccountChangeRsp> selectAccountChangeByPage(ReqAccountChange req) throws TuiaMediaException;

    /**
     * insertAccountChange:(增加媒体账户月资金记录). <br/>
     *
     * @author ZFZ
     * @param accountChangeDto
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    void insertAccountChange(AccountChangeDto accountChangeDto) throws TuiaMediaException;
    
    /**
     * 
     * selectAccountChangeListByIds:(根据媒体ids查询媒体账户). <br/>
     *
     * @param ids
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    List<AccountChangeDto> selectAccountChangeListByIds(List<Long> ids) throws TuiaMediaException;
    /**
     * 
     * selectAccountChangeById:(通过Id查询结算流水信息). <br/>
     *
     * @param id
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    AccountChangeDto selectAccountChangeById(Long id)throws TuiaMediaException ;
    
    /**
     * 
     * selectAccountChangeByMediaId:(通过媒体用户Id查询最后一条结算流水信息). <br/>
     *
     * @author ZFZ
     * @param mediaId
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    AccountChangeDto selectAccountChangeByMediaId(Long mediaId)throws TuiaMediaException ;
    
    /**
     * 
     * exportAccountChangeList:(查询媒体用户资金记录). <br/>
     *
     * @param req
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    List<AccountChangeDto> selectAccountChangeList(ReqAccountChange req)throws TuiaMediaException;
    
    /**
     * 
     * exportAccountChange:(媒体账户资金流水导出). <br/>
     *
     * @param req
     * @param out
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    void exportAccountChange(ReqAccountChange req, OutputStream out)throws TuiaMediaException;
    
}
