package cn.com.duiba.tuia.media.service;

import java.util.List;

import cn.com.duiba.tuia.media.api.dto.req.ReqActivitySort;
import cn.com.duiba.tuia.media.api.dto.req.ReqIdAndType;
import cn.com.duiba.tuia.media.api.dto.rsp.RspActivityDto;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.domain.ActivitySortDto;

/**
 * Function: ActivitySortService
 *
 * @author xuyenan
 * @createTime 2016/10/24
 */
public interface ActivitySortService {

    /**
     * insertBatchActivitySort:(批量添加活动). <br/>
     *
     * @author ZFZ
     * @param activitySortDtoList
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    int insertBatchActivitySort(List<ActivitySortDto> activitySortDtoList) throws TuiaMediaException;

    /**
     * selectByCondition:(根据条件查询). <br/>
     *
     * @author ZFZ
     * @param reqActivitySort
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    List<ActivitySortDto> selectByCondition(ReqActivitySort reqActivitySort) throws TuiaMediaException;

    /**
     * selectByConditionAmount:(根据条件查询时的数量). <br/>
     *
     * @author ZFZ
     * @param reqActivitySort
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    int selectByConditionAmount(ReqActivitySort reqActivitySort) throws TuiaMediaException;

    /**
     * deleteActivity:(移除定制活动). <br/>
     *
     * @author ZFZ
     * @param slotId
     * @param activityId
     * @param activityType
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    boolean deleteActivity(Long activityId, Integer activityType, Long slotId) throws TuiaMediaException;

    /**
     * getMaxSortValueActivitySortDto:(获取某一广告位下所有活动中排序值最大的一个). <br/>
     *
     * @author ZFZ
     * @param slotId
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    ActivitySortDto getMaxSortValueActivitySortDto(Long slotId) throws TuiaMediaException;

    /**
     * 给活动推荐引擎提供的接口：根据媒体查询有效活动
     * 
     * @param appId
     * @return
     * @throws TuiaMediaException
     */
    List<RspActivityDto> getActivityForRecommendByApp(Long appId) throws TuiaMediaException;

    /**
     * 给活动推荐引擎提供的接口：根据媒体广告位查询有效活动
     * 
     * @param slotId
     * @return
     * @throws TuiaMediaException
     */
    List<RspActivityDto> getActivityForRecommendBySlot(Long slotId) throws TuiaMediaException;

    /**
     * addActivitySort
     * 
     * @param slotId
     * @param idAndTypes
     * @return 成功条数
     */
    int addActivitySort(Long slotId, List<ReqIdAndType> idAndTypes);

    /**
     * addDefaultActivitySort
     * 
     * @param slotId
     * @return 成功条数
     */
    int addDefaultActivitySort(Long slotId);

    /**
     * sortActivity
     * 
     * @param slotId
     * @param activityId
     * @param activityType
     * @param destLocation
     * @return
     * @throws TuiaMediaException
     */
    boolean sortActivity(Long slotId, Long activityId, Integer activityType, int destLocation) throws TuiaMediaException;

    /**
     * 给活动中心提供的查询接口
     *
     * @param slotId 广告位ID，暂时没用到，以后可能会用
     */
    List<RspActivityDto> getActivityForCenter(Long slotId) throws TuiaMediaException;
}
