/**
 * Project Name:manager-service<br>
 * File Name:BaseService.java<br>
 * Package Name:cn.com.duiba.tuia.manager.service<br>
 * Date:2016年9月8日下午3:58:14<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 *
 */
package cn.com.duiba.tuia.media.service;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.wolf.dubbo.DubboResult;


/**
 * ClassName: BaseService <br/>
 * date: 2016年9月8日 下午3:58:14 <br/>
 *
 * @author xiawei
 * @version 
 * @since JDK 1.6
 */
public class BaseService {

    /** The logger. */
    protected Logger logger = LoggerFactory.getLogger(getClass());

    protected <T> void doTuiaMediaException(DubboResult<T> result, String callInterface)
                                                                                                         throws TuiaMediaException {
        if (!result.isResultSuccess()) {
            String returnCode = result.getReturnCode();
            String msg = result.getMsg();
            // 创建失败
            logger.error("[TuiaMedia] " + callInterface + " failed, because of=[{}] and the returnCode=[{}]",
                         result.getMsg(), returnCode);
            if (returnCode.endsWith("TM-9999999")) {
                // 如果不是tuia-core发生的未知错误， 则把错误描述返回给前端
                msg = "发生未知错误";
                returnCode = "9999999";
            }
            throw new TuiaMediaException(returnCode, msg);
        }
    }
}
