/**
 * Project Name:media-biz File Name:MediaAppStatisticsService.java Package Name:cn.com.duiba.tuia.media.service
 * Date:2016年10月10日下午4:31:33 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.media.service;

import java.util.List;

import cn.com.duiba.tuia.media.api.dto.MeidaActivitySlotStatisticsDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqSlotLineStatisticsByPageDto;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;

/**
 * ClassName:MediaAppStatisticsService <br/>
 * Function: 媒体app统计数据. <br/>
 * Date: 2016年10月10日 下午4:31:33 <br/>
 * 
 * @author guyan
 * @version
 * @since JDK 1.6
 * @see
 */
public interface SlotLineStatisticsService {

    /**
     * 
     * getStatisticsDataByDate:(根据开始日期和结束日期 获取 总的 '点击量','曝光量','eCPM','预计收入' 统计数据). <br/>
     *
     * @author ZFZ
     * @param param
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    List<MeidaActivitySlotStatisticsDto> getStatisticsDataByDate(ReqSlotLineStatisticsByPageDto param) throws TuiaMediaException;

    /**
     * 
     * getMediaAppStatisticsData:(获取媒体app统计数据). <br/>
     *
     * @author ZFZ
     * @param param
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    List<MeidaActivitySlotStatisticsDto> getMediaAppStatisticsData(ReqSlotLineStatisticsByPageDto param) throws TuiaMediaException;

    /**
     * 
     * getSlotStatisticsData:(获取广告位统计数据). <br/>
     *
     * @author ZFZ
     * @param param
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    List<MeidaActivitySlotStatisticsDto> getSlotStatisticsData(ReqSlotLineStatisticsByPageDto param) throws TuiaMediaException;

    /**
     * 
     * getMediaAppDataAmount:(获取媒体app总数). <br/>
     *
     * @author ZFZ
     * @param param
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    int getMediaAppDataAmount(ReqSlotLineStatisticsByPageDto param) throws TuiaMediaException;

    /**
     * 获取广告位总数
     * 
     * @param param
     * @return
     * @throws TuiaMediaException
     */
    int getSlotDataAmount(ReqSlotLineStatisticsByPageDto param) throws TuiaMediaException;

}
