/**
 * Project Name:media-biz<br/>
 * File Name:AdsenseService.java<br/>
 * Package Name:cn.com.duiba.tuia.media.service<br/>
 * Date:2016年9月26日下午7:24:58<br/>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.media.service;

import java.util.List;

import cn.com.duiba.tuia.media.api.dto.PageResultDto;
import cn.com.duiba.tuia.media.api.dto.SlotDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqGetSlotsByPageDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqUpdateSlot;
import cn.com.duiba.tuia.media.api.dto.rsp.RspAdsenseSlotListDto;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.model.IdAndName;
import cn.com.duiba.tuia.media.model.req.ReqCreateSlot;
import cn.com.duiba.tuia.media.model.req.ReqEditSlotEnableStatus;
import cn.com.duiba.tuia.media.model.req.ReqSlotList;
import cn.com.duiba.tuia.media.model.rsp.RspPageResult;
import cn.com.duiba.tuia.media.model.rsp.RspSlot;

/**
 * 广告位service <br/>
 * Date: 2016年9月26日 下午7:24:58 <br/>
 * .
 *
 * @author ZFZ
 * @version
 * @since JDK 1.6
 * @see
 */
public interface SlotService {

    /**
     * 创建广告位. <br/>
     *
     * @param req the req
     * @return true, if insert
     * @throws TuiaMediaException the tuia media exception
     * @author ZFZ
     * @since JDK 1.6
     */
    Boolean insert(ReqCreateSlot req) throws TuiaMediaException;

    /**
     * 修改广告位. <br/>
     *
     * @param param the param
     * @return true, if update
     * @throws TuiaMediaException the tuia media exception
     * @author ZFZ
     * @since JDK 1.6
     */
    Boolean update(ReqUpdateSlot param) throws TuiaMediaException;

    /**
     * 查询广告位列表.
     *
     * @param param the param
     * @return 广告位列表
     * @throws TuiaMediaException the tuia media exception
     */
    RspPageResult<RspSlot> selectListByPage(ReqSlotList param) throws TuiaMediaException;

    /**
     * 管理端分页查询广告位列表.
     *
     * @param param the param
     * @return 广告位列表
     * @throws TuiaMediaException the tuia media exception
     */
    PageResultDto<RspAdsenseSlotListDto> selectAdsenseListByPage(ReqGetSlotsByPageDto param) throws TuiaMediaException;

    /**
     * 修改广告位开启/关闭状态. <br/>
     *
     * @param param the param
     * @return true, if update enable status
     * @throws TuiaMediaException the tuia media exception
     * @author ZFZ
     * @since JDK 1.6
     */
    Boolean updateEnableStatus(ReqEditSlotEnableStatus param) throws TuiaMediaException;

    /**
     * Select by id.
     *
     * @param slotId the slot id
     * @return the slot dto
     * @throws TuiaMediaException the tuia media exception
     */
    SlotDto selectById(Long slotId) throws TuiaMediaException;

    /**
     * 批量更新广告位状态.
     *
     * @param mediaIds the media ids
     * @param checkType the check type
     * @return true, if batch update check status
     * @throws TuiaMediaException the tuia media exception
     */
    boolean batchUpdateCheckStatus(List<Long> mediaIds, Integer checkType) throws TuiaMediaException;

    /**
     * 获取广告位集合.
     *
     * @param slotIds the slot ids
     * @return the list detail
     * @throws TuiaMediaException the tuia media exception
     */
    List<SlotDto> getListDetail(List<Long> slotIds) throws TuiaMediaException;

    /**
     * 通过广告位名称模糊查询slotId集合.
     *
     * @param slotName the slot name
     * @return the list< long>
     * @throws TuiaMediaException the tuia media exception
     */
    List<Long> selectIdsByName(String slotName) throws TuiaMediaException;

    /**
     * 通过slotsId批量查询.
     *
     * @param slotIds the slot ids
     * @return the list< id and name>
     * @throws TuiaMediaException the tuia media exception
     */
    List<IdAndName> selectAppIdAndName(List<Long> slotIds) throws TuiaMediaException;

    /**
     * 修改广告部分属性
     *
     * @param slotDto
     * @return boolean
     */
    Boolean updateSlot(SlotDto slotDto) throws TuiaMediaException;

    /**
     * 删除规则时需要禁用所有关联的广告位
     *
     * @param msId 规格ID
     * @return Boolean
     */
    Boolean closeSlotByMsId(Long msId) throws TuiaMediaException;

    /**
     * 通过广告ID删除广告信息. <br/>
     *
     * @param slotId
     * @param mediaId
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    Boolean deleteSlotById(Long slotId, Long mediaId) throws TuiaMediaException;
}
