/**
 * Project Name:media-biz<br>
 * File Name:StatisticsService.java<br>
 * Package Name:cn.com.duiba.tuia.media.service<br>
 * Date:2016年10月10日下午4:31:50<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.media.service;

import java.util.List;

import cn.com.duiba.tuia.media.api.dto.MeidaActivitySlotStatisticsDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqMediaAppStatisticsDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqSlotStatisticsDto;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;

/**
 * ClassName: StatisticsService <br/>
 * date: 2016年10月10日 下午4:31:50 <br/>
 * .
 *
 * @author xiawei
 * @version
 * @since JDK 1.6
 */
public interface SlotStatisticsService {

    /**
     * getAdsenseDataAmount:(分页统计广告位数据总数.). <br/>
     *
     * @author ZFZ
     * @param req
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    int getAdsenseDataAmount(ReqSlotStatisticsDto req) throws TuiaMediaException;

    /**
     * getAdsenseDataByPage:(分页统计广告位数据.). <br/>
     *
     * @author ZFZ
     * @param req
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    List<MeidaActivitySlotStatisticsDto> getAdsenseDataByPage(ReqSlotStatisticsDto req) throws TuiaMediaException;

    /**
     * getMediaDataAmount:(分页统计媒体数据总数). <br/>
     *
     * @author ZFZ
     * @param req
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    int getMediaDataAmount(ReqMediaAppStatisticsDto req) throws TuiaMediaException;

    /**
     * getMediaDataByPage:(分页统计媒体数据). <br/>
     *
     * @author ZFZ
     * @param req
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    List<MeidaActivitySlotStatisticsDto> getMediaDataByPage(ReqMediaAppStatisticsDto req)throws TuiaMediaException;
}
