/**
 * Project Name:media-biz<br>
 * File Name:SmsService.java<br>
 * Package Name:cn.com.duiba.tuia.media.service<br>
 * Date:2016年9月26日下午2:02:48<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.media.service;

import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.model.req.ReqSendSMS;

/**
 * ClassName: SmsService <br/>
 * Function: 短信Service. <br/>
 * date: 2016年9月26日 下午2:02:48 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
public interface SmsService {

    /**
     * 发送验证码.
     *
     * @param req the req
     * @return true, if send
     * @throws TuiaMediaException the tuia media exception
     */
    Boolean send(ReqSendSMS req) throws TuiaMediaException;
    
    /**
     * 
     * verify:(校验短信验证码). <br/>
     *
     * @author ZFZ
     * @param type
     * @param phone
     * @param code
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    Boolean verify(int type, String phone, String code) throws TuiaMediaException;
}
