/**
 * Project Name:media-biz<br>
 * File Name:StrategyService.java<br>
 * Package Name:cn.com.duiba.tuia.media.service<br>
 * Date:2016年9月27日上午11:39:40<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.media.service;

import java.util.List;

import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.domain.ShieldStrategyDto;
import cn.com.duiba.tuia.media.model.req.ReqShieldListStrategy;
import cn.com.duiba.tuia.media.model.req.ReqStrategyPageQuery;
import cn.com.duiba.tuia.media.model.rsp.RspIdAndValue;
import cn.com.duiba.tuia.media.model.rsp.RspPageResult;
import cn.com.duiba.tuia.media.model.rsp.RspShieldStrategy;
import cn.com.duiba.tuia.media.model.rsp.RspStrategyList;

/**
 * ClassName: StrategyService <br/>
 * Function: 屏蔽策略. <br/>
 * date: 2016年9月27日 上午11:39:40 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
public interface StrategyService {

    /**
     * 分页查询屏蔽策略列表.
     *
     * @param req the req
     * @return the page list
     * @throws TuiaMediaException the tuia media exception
     */
    RspPageResult<RspStrategyList> getPageList(ReqStrategyPageQuery req) throws TuiaMediaException;

    /**
     * 删除屏蔽策略.
     *
     * @param mediaId 媒体用户ID
     * @param strategyId 屏蔽策略id
     * @return true, if delete
     * @throws TuiaMediaException the tuia media exception
     */
    Boolean delete(Long mediaId, Long strategyId) throws TuiaMediaException;

    /**
     * 
     * create:(创建屏蔽策略.). <br/>
     *
     * @author ZFZ
     * @param req
     * @param mediaId
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    Boolean create(ReqShieldListStrategy req, Long mediaId) throws TuiaMediaException;

    /**
     * 
     * update:(更新屏蔽策略[业务平台使用]). <br/>
     *
     * @author ZFZ
     * @param req
     * @param mediaId
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    Boolean update(ReqShieldListStrategy req, Long mediaId) throws TuiaMediaException;
    
    /**
     * 
     * updateByManager:(更新广告位屏蔽策略[管理端使用]). <br/>
     *
     * @author ZFZ
     * @param strategyDto
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    Boolean updateByManager(ShieldStrategyDto strategyDto) throws TuiaMediaException;

    /**
     * 获取屏蔽策略详情.
     *
     * @param strategyId the strategy id
     * @return the list
     * @throws TuiaMediaException the tuia media exception
     */
    RspShieldStrategy getDetail(Long strategyId) throws TuiaMediaException;

    /**
     * 获取屏蔽策略列表.
     *
     * @param mediaId 媒体用户Id
     * @return the list
     * @throws TuiaMediaException the tuia media exception
     */
    List<RspIdAndValue> getListByMediaId(Long mediaId) throws TuiaMediaException;
}
