package cn.com.duiba.tuia.media.service.impl;

import java.util.ArrayList;
import java.util.List;

import cn.com.duiba.tuia.media.api.constant.ActivityConstant;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import com.google.common.collect.Lists;

import cn.com.duiba.tuia.media.api.dto.req.ReqActivitySlotDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspActivitySlotDto;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.ActivitySlotDAO;
import cn.com.duiba.tuia.media.dao.ActivitySortDAO;
import cn.com.duiba.tuia.media.dao.SlotDAO;
import cn.com.duiba.tuia.media.dataobject.ActivitySlotDO;
import cn.com.duiba.tuia.media.service.ActivitySlotService;

/**
 * @author xuyenan
 * @createTime 2016/12/21
 */
@Service("activitySlotService")
public class ActivitySlotServiceImpl implements ActivitySlotService {

    @Autowired
    private ActivitySlotDAO activitySlotDAO;

    @Autowired
    private SlotDAO         slotDAO;

    @Autowired
    private ActivitySortDAO activitySortDAO;

    @Override
    public Boolean addSlots(List<Long> slotIds) throws TuiaMediaException {
        if (CollectionUtils.isEmpty(slotIds)) {
            return true;
        }
        List<ActivitySlotDO> list = new ArrayList<>(slotIds.size());
        for (Long slotId : slotIds) {
            ActivitySlotDO activitySlotDO = new ActivitySlotDO();
            activitySlotDO.setSlotId(slotId);
            // 过滤已经添加过的广告位
            if (activitySlotDAO.getBySlotId(slotId) == null) {
                list.add(activitySlotDO);
            }
        }
        activitySlotDAO.insertBatch(list);
        return true;
    }

    @Transactional
    @Override
    public Boolean deleteSlot(Long slotId) throws TuiaMediaException {
        activitySlotDAO.delete(slotId);
        activitySortDAO.deleteAllSlotActivity(slotId);
        return true;
    }

    @Override
    public List<RspActivitySlotDto> getList(ReqActivitySlotDto req) throws TuiaMediaException {
        List<Long> slotIds = new ArrayList<>();
        // 根据名字模糊匹配广告位ID列表
        if (StringUtils.isNotEmpty(req.getName())) {
            List<Long> ids = slotDAO.selectIdsByName(req.getName());
            if (CollectionUtils.isEmpty(ids)) {
                return Lists.newArrayList();
            }
            slotIds.addAll(ids);
        }
        req.setSort("gmt_modified");
        req.setOrder("desc");
        req.setRowStart(req.getPageSize() * (req.getCurrentPage() - 1));
        req.setIdList(slotIds);
        return activitySlotDAO.getList(req);
    }

    @Override
    public int getListAmount(ReqActivitySlotDto req) throws TuiaMediaException {
        return activitySlotDAO.getListAmount(req);
    }

    @Override
    public ActivitySlotDO getBySlotId(Long slotId) throws TuiaMediaException {
        return activitySlotDAO.getBySlotId(slotId);
    }

    @Override
    public Boolean updateDirectMode(Long slotId, Integer directMode) throws TuiaMediaException {
        if (ActivityConstant.DIRECT_ADVERT_MODE_ONLY != directMode && ActivityConstant.DIRECT_ADVERT_MODE_PRIOR != directMode) {
            return false;
        }
        return activitySlotDAO.update(slotId, directMode) == 1;
    }
}
