/**
 * Project Name:media-biz<br>
 * File Name:ActivityStatisticsDayServiceImpl.java<br>
 * Package Name:cn.com.duiba.tuia.media.service.impl<br>
 * Date:2016年10月18日下午3:28:23<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.media.service.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.ActivityStatisticsDayDAO;
import cn.com.duiba.tuia.media.domain.ActivityStatisticsDayDto;
import cn.com.duiba.tuia.media.model.req.ReqActivityData;
import cn.com.duiba.tuia.media.service.ActivityStatisticsDayService;

/**
 * ClassName: ActivityStatisticsDayServiceImpl <br/>
 * Function: 活动数据. <br/>
 * date: 2016年10月18日 下午3:28:23 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
@Service
public class ActivityStatisticsDayServiceImpl extends BaseCacheService implements ActivityStatisticsDayService {

    @Autowired
    private ActivityStatisticsDayDAO activityStatisticsDayDAO;

    @Override
    public int selectAmountByPage(ReqActivityData req) throws TuiaMediaException {
        return activityStatisticsDayDAO.selectAmountByPage(req);
    }

    @Override
    public List<ActivityStatisticsDayDto> selectListByPage(ReqActivityData req) throws TuiaMediaException {
        return activityStatisticsDayDAO.selectListByPage(req);
    }

    @Override
    public int selectAmountByDetail(ReqActivityData req) throws TuiaMediaException {
        return activityStatisticsDayDAO.selectAmountByDetail(req);
    }

    @Override
    public List<ActivityStatisticsDayDto> selectListByDetail(ReqActivityData req) throws TuiaMediaException {
        return activityStatisticsDayDAO.selectListByDetail(req);
    }

    @Override
    public List<ActivityStatisticsDayDto> selectExposureAndLaunchAdvert(List<Long> activityIds,
                                                                        Long activityAppId) throws TuiaMediaException {
        return activityStatisticsDayDAO.selectExposureAndLaunchAdvert(activityIds, activityAppId);
    }

}
