package cn.com.duiba.tuia.media.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import cn.com.duiba.tuia.media.api.constant.AdvertValidStatusConstant;
import cn.com.duiba.tuia.media.api.dto.rsp.RspActivityAdvertDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.RemoteGoodsCouponBackendService;
import cn.com.duiba.goods.center.api.remoteservice.dto.ACGStockDto;
import cn.com.duiba.tuia.core.api.dto.AdvertDetailDto;
import cn.com.duiba.tuia.core.api.dto.AdvertDto;
import cn.com.duiba.tuia.core.api.remoteservice.RemoteAdvertBackendService;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.service.AdvertService;
import cn.com.duiba.tuia.media.service.BaseService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.springframework.util.CollectionUtils;

/**
 * @author xuyenan
 * @createTime 2017/1/12
 */
@Service
public class AdvertServiceImpl extends BaseService implements AdvertService {

    @Autowired
    private RemoteAdvertBackendService      remoteAdvertBackendService;

    @Autowired
    private RemoteGoodsCouponBackendService remoteGoodsCouponBackendService;

    @Override
    public Map<Long, AdvertDto> getAdvertListByIds(List<Long> advertIds) throws TuiaMediaException {
        DubboResult<List<AdvertDto>> result = remoteAdvertBackendService.getAdvertsByIds(advertIds);
        doTuiaMediaException(result, "AdvertService.getAdvertListByIds");
        Map<Long, AdvertDto> map = new HashMap<>();
        if (result.getResult() != null) {
            for (AdvertDto advertDto : result.getResult()) {
                map.put(advertDto.getId(), advertDto);
            }
        }
        return map;
    }

    @Override
    public AdvertDetailDto getAdvertDetailById(Long advertId) {
        DubboResult<AdvertDetailDto> result = remoteAdvertBackendService.getAdvertDetailById(advertId);
        return result.getResult();
    }

    @Override
    public ACGStockDto findGoodsStock(Long couponId) {
        DubboResult<ACGStockDto> result = remoteGoodsCouponBackendService.findGoodsStock(GoodsTypeEnum.ADVERT, couponId);
        return result.getResult();
    }

    @Override
    public List<RspActivityAdvertDto> getAdvertsByIds(List<Long> ids) throws TuiaMediaException {
        List<RspActivityAdvertDto> result = new ArrayList<>();
        if (!CollectionUtils.isEmpty(ids)) {
            Map<Long, AdvertDto> map = getAdvertListByIds(ids);
            for (Long id : ids) {
                // 获取广告基本信息
                AdvertDto advertDto = map.get(id);
                if (advertDto != null) {
                    // 只能选择推啊的广告券
                    if (AdvertDto.TUIA_ADVERT_SOURCE != advertDto.getSource()) {
                        continue;
                    }
                    RspActivityAdvertDto rspActivityAdvertDto = new RspActivityAdvertDto();
                    rspActivityAdvertDto.setId(advertDto.getId());
                    rspActivityAdvertDto.setName(advertDto.getName());
                    rspActivityAdvertDto.setStatus(advertDto.getValidStatus());
                    rspActivityAdvertDto.setStatusText(AdvertValidStatusConstant.getValidStatusText(advertDto.getValidStatus()));
                    // 获取广告主名称和优惠券信息
                    AdvertDetailDto advertDetailDto = getAdvertDetailById(id);
                    if (advertDetailDto != null) {
                        rspActivityAdvertDto.setCompanyName(advertDetailDto.getAdvertiserName());
                        // 获取库存总量和剩余量
                        if (advertDetailDto.getAdvertCoupon() != null) {
                            ACGStockDto acgStockDto = findGoodsStock(advertDetailDto.getAdvertCoupon().getId());
                            if (acgStockDto != null) {
                                rspActivityAdvertDto.setInitInventory(acgStockDto.getTotalStock());
                                rspActivityAdvertDto.setCurInventory(acgStockDto.getStock());
                            }
                        }
                    }
                    result.add(rspActivityAdvertDto);
                }
            }
        }
        return result;
    }
}
