/**
 * Project Name:media-biz<br>
 * File Name:BaseCacheService.java<br>
 * Package Name:cn.com.duiba.tuia.media.service<br>
 * Date:2016年9月30日下午4:51:24<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.media.service.impl;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.wolf.redis.RedisClient;

import com.alibaba.ttl.threadpool.TtlExecutors;

/**
 * ClassName: BaseCacheService <br/>
 * Function: 缓存基础层. <br/>
 * date: 2016年9月30日 下午4:51:24 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
@Service
public class BaseCacheService {

    /** 一周. */
    protected static final int ONE_WEEK        = 60 * 60 * 24 * 7;

    /** The logger. */
    protected Logger           logger          = LoggerFactory.getLogger(getClass());

    protected ExecutorService  executorService = TtlExecutors.getTtlExecutorService(Executors.newFixedThreadPool(10));

    @Autowired
    protected RedisClient      redisClient;
}
