package cn.com.duiba.tuia.media.service.impl;

import java.util.ArrayList;
import java.util.List;

import cn.com.duiba.tuia.media.api.constant.MaterialSpecificationConstant;
import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.dao.MaterialSpecificationDAO;
import cn.com.duiba.tuia.media.dataobject.MaterialSpecificationDO;
import cn.com.duiba.tuia.media.dataobject.MediaAppMsDO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.MediaAppMsDAO;
import cn.com.duiba.tuia.media.service.MediaAppMsService;

/**
 * @author xuyenan
 * @createTime 2016/12/20
 */
@Service("mediaAppMsService")
public class MediaAppMsServiceImpl implements MediaAppMsService {

    @Autowired
    private MediaAppMsDAO            mediaAppMsDAO;

    @Autowired
    private MaterialSpecificationDAO materialSpecificationDAO;

    @Transactional
    @Override
    public Boolean msDirectToMediaApp(Long msId, List<Long> appIds, Integer directStatus) throws TuiaMediaException {
        if (MaterialSpecificationConstant.MS_DIRECT != directStatus && MaterialSpecificationConstant.MS_NOT_DIRECT != directStatus) {
            throw new TuiaMediaException(ErrorCode.E0001005);
        }
        // 更新规格定向字段
        MaterialSpecificationDO materialSpecificationDO = new MaterialSpecificationDO();
        materialSpecificationDO.setId(msId);
        materialSpecificationDO.setIsDirect(directStatus);
        materialSpecificationDAO.update(materialSpecificationDO);
        // 规格定向媒体更新
        mediaAppMsDAO.delete(msId);
        if (!CollectionUtils.isEmpty(appIds)) {
            List<MediaAppMsDO> list = new ArrayList<>(appIds.size());
            for (Long appId : appIds) {
                MediaAppMsDO mediaAppMsDO = new MediaAppMsDO();
                mediaAppMsDO.setMsId(msId);
                mediaAppMsDO.setMediaAppId(appId);
                list.add(mediaAppMsDO);
            }
            mediaAppMsDAO.insertBatch(list);
        }
        return true;
    }

    @Override
    public List<Long> getMsDirectedMediaApp(Long msId) throws TuiaMediaException {
        return mediaAppMsDAO.getAppIdsByMsId(msId);
    }

    @Override
    public List<Long> getMsIdsExceptTheMediaApp(Long mediaId) throws TuiaMediaException {
        return mediaAppMsDAO.getMsIdsExceptTheMediaApp(mediaId);
    }

    @Override
    public List<Long> getMsIdsByMediaApp(Long mediaId) throws TuiaMediaException {
        return mediaAppMsDAO.getMsIdsByMediaApp(mediaId);
    }
}
