/**
 * Project Name:media-biz File Name:MediaAppStatisticsServiceImpl.java Package Name:cn.com.duiba.tuia.media.service.impl
 * Date:2016年10月10日下午4:31:49 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.media.service.impl;

import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.ListUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.tuia.media.api.dto.MeidaActivitySlotStatisticsDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqMediaAppStatisticsDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqSlotLineStatisticsByPageDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqSlotStatisticsDto;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.SlotStatisticsDAO;
import cn.com.duiba.tuia.media.service.SlotLineStatisticsService;

/**
 * ClassName:MediaAppStatisticsServiceImpl <br/>
 * Function: 广告位折线统计数据. <br/>
 * Date: 2016年10月10日 下午4:31:49 <br/>
 * 
 * @author guyan
 * @version
 * @since JDK 1.6
 * @see
 */
@Service
public class SoltLineStatisticsServiceImpl implements SlotLineStatisticsService {

    @Autowired
    SlotStatisticsDAO slotStatisticDao;

    @SuppressWarnings("unchecked")
    @Override
    public List<MeidaActivitySlotStatisticsDto> getMediaAppStatisticsData(ReqSlotLineStatisticsByPageDto param)
                                                                                                  throws TuiaMediaException {
        ReqMediaAppStatisticsDto dto = new ReqMediaAppStatisticsDto();
        dto.setStartTime(param.getStartDate());
        dto.setEndTime(param.getEndDate());
        dto.setMediaId(param.getMediaId());
        List<MeidaActivitySlotStatisticsDto> mediaAppList;
        mediaAppList = slotStatisticDao.selectListMediaDataByPage(dto);
        
        if (CollectionUtils.isEmpty(mediaAppList)) {
            return ListUtils.EMPTY_LIST;
        }
        return mediaAppList;
    }

    @SuppressWarnings("unchecked")
    @Override
    public List<MeidaActivitySlotStatisticsDto> getSlotStatisticsData(ReqSlotLineStatisticsByPageDto param) throws TuiaMediaException {
        ReqSlotStatisticsDto dto = new ReqSlotStatisticsDto();
        dto.setStartTime(param.getStartDate());
        dto.setEndTime(param.getEndDate());
        dto.setMediaId(param.getMediaId());
        List<MeidaActivitySlotStatisticsDto> slotList = slotStatisticDao.selectListSlotDataByPage(dto);
        if (CollectionUtils.isEmpty(slotList)) {
            return ListUtils.EMPTY_LIST;
        }
        return slotList;
    }

    @SuppressWarnings("unchecked")
    @Override
    public List<MeidaActivitySlotStatisticsDto> getStatisticsDataByDate(ReqSlotLineStatisticsByPageDto param) throws TuiaMediaException {
        List<MeidaActivitySlotStatisticsDto> dataList = slotStatisticDao.selectByDate(param);
        if (CollectionUtils.isEmpty(dataList)) {
            return ListUtils.EMPTY_LIST;
        }
        return dataList;
    }

    @Override
    public int getMediaAppDataAmount(ReqSlotLineStatisticsByPageDto param) throws TuiaMediaException {
        ReqMediaAppStatisticsDto dto = new ReqMediaAppStatisticsDto();
        dto.setStartTime(param.getStartDate());
        dto.setEndTime(param.getEndDate());
        dto.setMediaId(param.getMediaId());
        return slotStatisticDao.selectMediaDataAmount(dto);

    }
    @Override
    public int getSlotDataAmount(ReqSlotLineStatisticsByPageDto param) throws TuiaMediaException {
        ReqSlotStatisticsDto dto = new ReqSlotStatisticsDto();
        dto.setStartTime(param.getStartDate());
        dto.setEndTime(param.getEndDate());
        dto.setMediaId(param.getMediaId());
        return slotStatisticDao.selectSlotDataAmout(dto);
    }

}
