/**
 * 文件名： PptvGeetestUtils.java 此类描述的是： 作者: leiliang 创建时间: 2016年3月31日 上午11:47:31
 */
package cn.com.duiba.tuia.media.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.Socket;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.common.utils.MD5;
import cn.com.duiba.tuia.media.model.Captcha;

/**
 * @author: leiliang
 * @version:
 */
public class JiYanTool {

    /** 极验URL. */
    private static final String GEETEST_URL         = "api.geetest.com";

    /** The VAL i_ dat e_ url. */
    private static final String VALI_DATE_URL       = "/validate.php";

    /** The POR t_80. */
    private static final int    PORT_80             = 80;

    /** The VE r_ name. */
    private static final String VER_NAME            = "2.15.7.3.1";

    /** The SD k_ lang. */
    private static final String SDK_LANG            = "java";

    /** The logger. */
    private static Logger       logger              = LoggerFactory.getLogger(JiYanTool.class);

    /** The Constant DEFAULT_CAPTCHA_ID. */
    private static final String DEFAULT_CAPTCHA_ID  = "9fbc62e56634523d27bc451b1a6a0443";

    /** The Constant DEFAULT_PRIVATE_KEY. */
    private static final String DEFAULT_PRIVATE_KEY = "979d8ac2255f30f1ef8a8ca6ba681100";

    /** The ji yan private key. */
    private static String       jiYanPrivateKey;

    /** The ji yan captcha id. */
    private static String       jiYanCaptchaId;

    private JiYanTool           jy;

    public JiYanTool getJiYanTool() {
        if (jy == null) {
            jy = new JiYanTool();
        }
        return jy;
    }

    /**
     * @param jiYanPrivateKey 要设置的 jiYanPrivateKey
     */
    public static void setJiYanPrivateKey(String jiYanPrivateKey) {
        JiYanTool.jiYanPrivateKey = jiYanPrivateKey;
    }

    /**
     * @param jiYanCaptchaId 要设置的 jiYanCaptchaId
     */
    public static void setJiYanCaptchaId(String jiYanCaptchaId) {
        JiYanTool.jiYanCaptchaId = jiYanCaptchaId;
    }

    /**
     * 获取极验秘钥.
     *
     * @return the ji yan private key
     */
    public static String getJiYanPrivateKey() {
        if (StringUtils.isBlank(jiYanPrivateKey)) {
            return DEFAULT_PRIVATE_KEY;
        }
        return jiYanPrivateKey;
    }

    /**
     * 获取极验公钥ID.
     *
     * @return the ji yan captcha id
     */
    public static String getJiYanCaptchaId() {
        if (StringUtils.isBlank(jiYanCaptchaId)) {
            return DEFAULT_CAPTCHA_ID;
        }
        return jiYanCaptchaId;
    }

    /**
     * 校验极验验证码.
     *
     * @param captchaVO the captcha vo
     * @throws TuiaMediaException the tuia exception
     */
    public static void authJiYanCode(Captcha captchaVO) throws TuiaMediaException {
        // 参数校验
        if (captchaVO == null) {
            logger.error("authJiYanCode error, because the captchaVO is null");
            throw new TuiaMediaException(ErrorCode.E0001007);
        }

        String seccode = captchaVO.getSeccode();
        String validate = captchaVO.getValidate();
        if (StringUtils.isBlank(captchaVO.getChallenge()) || StringUtils.isBlank(seccode)
            || StringUtils.isBlank(validate)) {
            logger.error("authJiYanCode error, because the param =[{}]", captchaVO);
            throw new TuiaMediaException(ErrorCode.E0001007);
        }

        doCheckJiYanCode(captchaVO, seccode, validate);

    }

    private static void doCheckJiYanCode(Captcha captchaVO, String seccode, String validate) throws TuiaMediaException {
        String query = String.format("seccode=%s&sdk=%s", seccode, SDK_LANG + "_" + VER_NAME);

        String encodeStr = MD5.md5(getJiYanPrivateKey() + "geetest" + captchaVO.getChallenge());
        if (!StringUtils.equals(validate, encodeStr)) {
            // 错误
            logger.error("authJiYanCode error, because the encodeStr=[{}], and the validate =[{}]", encodeStr, validate);
            throw new TuiaMediaException(ErrorCode.E0001007);
        }

        String response = doAuthJiYanCode(query);

        if (!response.equals(MD5.md5(seccode))) {
            logger.error("authJiYanCode error, because the response not equal seccode, and the response is:" + response);
            throw new TuiaMediaException(ErrorCode.E0001007);
        }
    }

    /**
     * 极验验证码校验.
     *
     * @param data the data
     * @return the string
     * @throws TuiaMediaException the tuia exception
     */
    private static String doAuthJiYanCode(String data) throws TuiaMediaException {
        try (Socket socket = new Socket(InetAddress.getByName(GEETEST_URL), PORT_80)) {
            String response = "error";
            BufferedWriter wr = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), "UTF8"));
            wr.write("POST " + VALI_DATE_URL + " HTTP/1.0\r\n");
            wr.write("Host: " + GEETEST_URL + "\r\n");
            wr.write("Content-Type: application/x-www-form-urlencoded\r\n");
            wr.write("Content-Length: " + data.length() + "\r\n");
            wr.write("\r\n"); // 以空行作为分割
            // 发送数据
            wr.write(data);
            wr.flush();
            // 读取返回信息
            BufferedReader rd = new BufferedReader(new InputStreamReader(socket.getInputStream(), "UTF-8"));
            String line;
            while ((line = rd.readLine()) != null) {
                response = line;
            }
            wr.close();
            rd.close();

            return response;
        } catch (Exception e) {
            logger.error("doAuthJiYanCode error, the data=[{}]", data, e);
            throw new TuiaMediaException(ErrorCode.E0001007, e);
        } 
    }
}
