/**
 * Project Name:media-biz<br>
 * File Name:RemoveDuplicateTool.java<br>
 * Package Name:cn.com.duiba.tuia.media.utils<br>
 * Date:2016年10月19日下午6:58:24<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.media.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import cn.com.duiba.tuia.core.api.dto.TagLevel;

import com.alibaba.dubbo.common.utils.CollectionUtils;

/**
 * ClassName: RemoveDuplicateTool <br/>
 * date: 2016年10月19日 下午6:58:24 <br/>
 *
 * @author xiawei
 * @version
 * @since JDK 1.6
 */
public class RemoveDuplicateTool {

    private RemoveDuplicateTool rdt;

    public RemoveDuplicateTool getRemoveDuplicateTool() {
        if (rdt == null) {
            rdt = new RemoveDuplicateTool();
        }
        return rdt;
    }

    /**
     * doRemoveDuplicate:(去除重复屏蔽标签). <br/>
     *
     * @author ZFZ
     * @param source
     * @return
     * @since JDK 1.6
     */
    public static List<TagLevel> doRemoveDuplicate(List<TagLevel> source) {
        List<TagLevel> target = null;
        if (CollectionUtils.isNotEmpty(source)) {
            Set<TagLevel> set = new HashSet<>(source);
            target = new ArrayList<>(set);
        }
        return target;
    }

    /**
     * doRemoveDuplicateUrl:(去除重复屏蔽Url). <br/>
     *
     * @author ZFZ
     * @param source
     * @return
     * @since JDK 1.6
     */
    public static List<String> doRemoveDuplicateUrl(List<String> source) {
        List<String> target = null;
        if (CollectionUtils.isNotEmpty(source)) {
            Set<String> set = new HashSet<>(source);
            target = new ArrayList<>(set);
        }
        return target;
    }
}
