/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.dao.impl;

import cn.com.duiba.tuia.media.api.dto.AccountDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqGetAccountByPageDto;
import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.AccountDAO;
import cn.com.duiba.tuia.media.dao.BaseDAO;
import cn.com.duiba.tuia.media.model.IdAndName;
import cn.com.duiba.tuia.media.model.req.ReqUpdateAccountBase;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository(value="accountDAO")
public class AccountDAOImpl
extends BaseDAO
implements AccountDAO {
    private String statusStr = "status";
    private String mediaIdStr = "mediaId";

    @Override
    public AccountDto selectById(Long mediaId) throws TuiaMediaException {
        try {
            return (AccountDto)this.getSqlSession().selectOne(this.getStamentNameSpace("selectById"), (Object)mediaId);
        }
        catch (Exception e) {
            this.logger.error("AccountDAO.selectById happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public AccountDto selectByEmail(String email) throws TuiaMediaException {
        try {
            return (AccountDto)this.getSqlSession().selectOne(this.getStamentNameSpace("selectByEmail"), (Object)email);
        }
        catch (Exception e) {
            this.logger.error("AccountDAO.selectByEmail happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public int updateEmailStatus(Long mediaId, Integer status) throws TuiaMediaException {
        try {
            HashMap<String, Number> param = new HashMap<String, Number>(2);
            param.put(this.mediaIdStr, mediaId);
            param.put(this.statusStr, status);
            return this.getSqlSession().update(this.getStamentNameSpace("updateEmailStatus"), param);
        }
        catch (Exception e) {
            this.logger.error("AccountDAO.selectByEmail happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public int updatePasswdByEmail(String email, String password) throws TuiaMediaException {
        try {
            HashMap<String, String> param = new HashMap<String, String>(2);
            param.put("email", email);
            param.put("password", password);
            return this.getSqlSession().update(this.getStamentNameSpace("updatePasswdByEmail"), param);
        }
        catch (Exception e) {
            this.logger.error("AccountDaoImpl.updatePasswdByEmail happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public int insert(AccountDto accountDto) throws TuiaMediaException {
        try {
            accountDto.setCheckStatus(Integer.valueOf(1));
            accountDto.setEmailStatus(Integer.valueOf(0));
            accountDto.setFreezeStatus(Integer.valueOf(0));
            accountDto.setGmtCreate(new Date());
            accountDto.setGmtModified(accountDto.getGmtCreate());
            return this.getSqlSession().insert(this.getStamentNameSpace("insert"), (Object)accountDto);
        }
        catch (Exception e) {
            this.logger.error("AccountDaoImpl.insert happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public int updateAccount(ReqUpdateAccountBase req) throws TuiaMediaException {
        try {
            return this.getSqlSession().update(this.getStamentNameSpace("updateAccount"), (Object)req);
        }
        catch (Exception e) {
            this.logger.error("AccountDaoImpl.updateAccount happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public int updateAuditData(AccountDto req) throws TuiaMediaException {
        try {
            req.setCheckStatus(Integer.valueOf(0));
            return this.getSqlSession().update(this.getStamentNameSpace("updateAuditData"), (Object)req);
        }
        catch (Exception e) {
            this.logger.error("AccountDaoImpl.updateAuditData happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public Integer selectMediaDataAmount(ReqGetAccountByPageDto req) throws TuiaMediaException {
        try {
            return (Integer)this.getSqlSession().selectOne(this.getStamentNameSpace("selectMediaDataAmount"), (Object)req);
        }
        catch (Exception e) {
            this.logger.error("MediaDAOImpl.selectMeidaDataAmount data happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public List<AccountDto> selectMediaDataByPage(ReqGetAccountByPageDto req) throws TuiaMediaException {
        try {
            return this.getSqlSession().selectList(this.getStamentNameSpace("selectMediaDataByPage"), (Object)req);
        }
        catch (Exception e) {
            this.logger.error("MediaDAOImpl.selectMediaDataByPage data happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public int updateCheckStatus(Long mediaId, Integer status) throws TuiaMediaException {
        try {
            HashMap<String, Number> paramMap = new HashMap<String, Number>(2);
            paramMap.put(this.mediaIdStr, mediaId);
            paramMap.put(this.statusStr, status);
            return this.getSqlSession().update(this.getStamentNameSpace("updateCheckStatus"), paramMap);
        }
        catch (Exception e) {
            this.logger.error("MediaDAOImpl.updateCheckStatus data happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public int updateFreezeStatus(Long mediaId, Integer status) throws TuiaMediaException {
        try {
            HashMap<String, Number> paramMap = new HashMap<String, Number>(2);
            paramMap.put(this.mediaIdStr, mediaId);
            paramMap.put(this.statusStr, status);
            return this.getSqlSession().update(this.getStamentNameSpace("updateFreezeStatus"), paramMap);
        }
        catch (Exception e) {
            this.logger.error("MediaDAOImpl.updateFreezeStatus data happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public int updateEmail(Long mediaId, String email) throws TuiaMediaException {
        try {
            HashMap<String, Object> paramMap = new HashMap<String, Object>(2);
            paramMap.put(this.mediaIdStr, mediaId);
            paramMap.put("email", email);
            return this.getSqlSession().update(this.getStamentNameSpace("updateEmail"), paramMap);
        }
        catch (Exception e) {
            this.logger.error("MediaDAOImpl.updateEmail data happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public AccountDto selectByPhone(String phone) throws TuiaMediaException {
        try {
            return (AccountDto)this.getSqlSession().selectOne(this.getStamentNameSpace("selectByPhone"), (Object)phone);
        }
        catch (Exception e) {
            this.logger.error("AccountDAO.selectByPhone happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public List<IdAndName> selectMediaIdAndEmails(List<Long> mediaIds) throws TuiaMediaException {
        try {
            return this.getSqlSession().selectList(this.getStamentNameSpace("selectMediaIdAndEmails"), mediaIds);
        }
        catch (Exception e) {
            this.logger.error("AccountDAO.selectEmails happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public void updateRoleType(Integer roleType, Long mediaId) throws TuiaMediaException {
        try {
            HashMap<String, Number> map = new HashMap<String, Number>(2);
            map.put("roleType", roleType);
            map.put("mediaId", mediaId);
            this.getSqlSession().update(this.getStamentNameSpace("updateRoleType"), map);
        }
        catch (Exception e) {
            this.logger.error("AccountDAO.updateRoleType happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public int updatePhoneNum(Long mediaId, String phoneNum) throws TuiaMediaException {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>(2);
            map.put("mediaId", mediaId);
            map.put("phoneNum", phoneNum);
            return this.getSqlSession().update(this.getStamentNameSpace("updatePhoneNum"), map);
        }
        catch (Exception e) {
            this.logger.error("MediaDAOImpl.updatePhoneNum data happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public List<AccountDto> selectAllListCache() throws TuiaMediaException {
        try {
            return this.getSqlSession().selectList(this.getStamentNameSpace("selectAllListCache"));
        }
        catch (Exception e) {
            this.logger.error("AccountDAO.selectAllListCache happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }
}

