/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.dao.impl;

import cn.com.duiba.tuia.media.api.dto.req.ReqActivitySlotDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspActivitySlotDto;
import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.ActivitySlotDAO;
import cn.com.duiba.tuia.media.dao.BaseDAO;
import cn.com.duiba.tuia.media.dataobject.ActivitySlotDO;
import java.util.HashMap;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository(value="activitySlotDAO")
public class ActivitySlotDAOImpl
extends BaseDAO
implements ActivitySlotDAO {
    @Override
    public int insertBatch(List<ActivitySlotDO> list) throws TuiaMediaException {
        try {
            if (CollectionUtils.isEmpty(list)) {
                return 0;
            }
            return this.getSqlSession().insert(this.getStamentNameSpace("insertBatch"), list);
        }
        catch (Exception e) {
            this.logger.error("ActivitySlotDAO.insertBatch happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public int delete(Long slotId) throws TuiaMediaException {
        try {
            return this.getSqlSession().delete(this.getStamentNameSpace("delete"), (Object)slotId);
        }
        catch (Exception e) {
            this.logger.error("ActivitySlotDAO.delete happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public List<RspActivitySlotDto> getList(ReqActivitySlotDto req) throws TuiaMediaException {
        try {
            return this.getSqlSession().selectList(this.getStamentNameSpace("getList"), (Object)req);
        }
        catch (Exception e) {
            this.logger.error("ActivitySlotDAO.getList happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public int getListAmount(ReqActivitySlotDto req) throws TuiaMediaException {
        try {
            return (Integer)this.getSqlSession().selectOne(this.getStamentNameSpace("getListAmount"), (Object)req);
        }
        catch (Exception e) {
            this.logger.error("ActivitySlotDAO.getListAmount happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public ActivitySlotDO getBySlotId(Long slotId) throws TuiaMediaException {
        try {
            return (ActivitySlotDO)this.getSqlSession().selectOne(this.getStamentNameSpace("getBySlotId"), (Object)slotId);
        }
        catch (Exception e) {
            this.logger.error("ActivitySlotDAO.getBySlotId happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public int update(Long slotId, Integer directMode) throws TuiaMediaException {
        try {
            HashMap<String, Number> map = new HashMap<String, Number>();
            map.put("slotId", slotId);
            map.put("directMode", directMode);
            return this.getSqlSession().update(this.getStamentNameSpace("update"), map);
        }
        catch (Exception e) {
            this.logger.error("ActivitySlotDAO.update happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }
}

