/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.remoteservice;

import cn.com.duiba.tuia.media.api.dto.ActivitySpmDto;
import cn.com.duiba.tuia.media.api.dto.MediaAppDto;
import cn.com.duiba.tuia.media.api.dto.PageResultDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqActivityDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqIdAndType;
import cn.com.duiba.tuia.media.api.dto.rsp.RspActivityAdvertDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspActivityDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspMaterialSpecificationDto;
import cn.com.duiba.tuia.media.api.remoteservice.RemoteActivityBackendService;
import cn.com.duiba.tuia.media.model.IdAndName;
import cn.com.duiba.tuia.media.parser.IdAndNameParser;
import cn.com.duiba.tuia.media.remoteservice.BaseRemoteService;
import cn.com.duiba.tuia.media.service.ActivityAdvertService;
import cn.com.duiba.tuia.media.service.ActivityService;
import cn.com.duiba.tuia.media.service.ActivitySpmService;
import cn.com.duiba.tuia.media.service.AdvertService;
import cn.com.duiba.tuia.media.service.MediaAppActivityService;
import cn.com.duiba.tuia.media.service.MediaAppService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class RemoteActivityBackendServiceImpl
extends BaseRemoteService
implements RemoteActivityBackendService {
    @Autowired
    private ActivityService activityService;
    @Autowired
    private MediaAppActivityService mediaAppActivityService;
    @Autowired
    private ActivityAdvertService activityAdvertService;
    @Autowired
    private MediaAppService mediaAppService;
    @Autowired
    private AdvertService advertService;
    @Autowired
    private ActivitySpmService activitySpmService;

    public DubboResult<List<RspActivityDto>> getByActivityIds(List<Long> activityIds) {
        try {
            List<RspActivityDto> rspActivityDtoList = this.activityService.getActivityByIds(activityIds);
            return DubboResult.successResult(rspActivityDtoList);
        }
        catch (Exception e) {
            this.logger.error("RemoteActivityBackendService.getByActivityIds is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<String> getActivityNameByIdAndType(Long id, Integer type) {
        try {
            String name = this.activityService.getActivityName(id, type);
            return DubboResult.successResult((Object)name);
        }
        catch (Exception e) {
            this.logger.error("RemoteActivityBackendService.getActivityByIdAndType is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<PageResultDto<RspActivityDto>> getPlanList(ReqActivityDto req) {
        try {
            return DubboResult.successResult((Object)new PageResultDto(this.activityService.getPlanListAmount(req), this.activityService.getPlanList(req), req.getPageSize().intValue()));
        }
        catch (Exception e) {
            this.logger.error("RemoteActivityBackendService.getPlanList is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<Boolean> addActivityPlan(List<ReqIdAndType> activities) {
        try {
            return DubboResult.successResult((Object)this.activityService.addActivityPlan(activities));
        }
        catch (Exception e) {
            this.logger.error("RemoteActivityBackendService.addActivityPlan is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<Boolean> deleteActivityPlan(Long activityId, Integer activityType) {
        try {
            return DubboResult.successResult((Object)this.activityService.deleteActivityPlan(activityId, activityType));
        }
        catch (Exception e) {
            this.logger.error("RemoteActivityBackendService.deleteActivityPlan is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<Boolean> changeActivityPlanEnable(Long activityId, Integer activityType, Integer enableStatus) {
        try {
            return DubboResult.successResult((Object)this.activityService.changeActivityPlanEnable(activityId, activityType, enableStatus));
        }
        catch (Exception e) {
            this.logger.error("RemoteActivityBackendService.changeActivityPlanEnable is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<Boolean> updateActivityPlan(ReqActivityDto reqActivityDto) {
        try {
            return DubboResult.successResult((Object)this.activityService.updateActivityPlan(reqActivityDto));
        }
        catch (Exception e) {
            this.logger.error("RemoteActivityBackendService.updateActivityPlan is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<RspActivityDto> getActivityPlanDetail(Long activityId, Integer activityType) {
        try {
            RspActivityDto rspActivityDto = this.activityService.getActivityPlanDetail(activityId, activityType);
            rspActivityDto = this.activityService.getMsItemContent(rspActivityDto);
            return DubboResult.successResult((Object)rspActivityDto);
        }
        catch (Exception e) {
            this.logger.error("RemoteActivityBackendService.getActivityPlanDetail is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<List<MediaAppDto>> getActivityDirectedMediaApp(Long activityId, Integer activityType) {
        try {
            List<Long> list = this.mediaAppActivityService.getActivityDirectedMediaApp(activityId, activityType);
            ArrayList<MediaAppDto> result = new ArrayList<MediaAppDto>();
            if (!CollectionUtils.isEmpty(list)) {
                List<IdAndName> apps = this.mediaAppService.selectAppIdAndName(list);
                for (IdAndName idAndName : apps) {
                    result.add(IdAndNameParser.parseToMediaAppDto(idAndName));
                }
            }
            return DubboResult.successResult(result);
        }
        catch (Exception e) {
            this.logger.error("RemoteActivityBackendService.activityDirectToMediaApp is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<Boolean> activityDirectToMediaApp(Long activityId, Integer activityType, Integer directStatus, List<Long> appIds) {
        try {
            return DubboResult.successResult((Object)this.mediaAppActivityService.activityDirectToMediaApp(activityId, activityType, directStatus, appIds));
        }
        catch (Exception e) {
            this.logger.error("RemoteActivityBackendService.activityDirectToMediaApp is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<List<RspActivityAdvertDto>> getActivityDirectedAdvert(Long activityId, Integer activityType) {
        try {
            List<Long> list = this.activityAdvertService.getActivityAdvertIds(activityId, activityType);
            return DubboResult.successResult(this.advertService.getAdvertsByIds(list));
        }
        catch (Exception e) {
            this.logger.error("RemoteActivityBackendService.getActivityDirectedAdvert is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<Boolean> activityDirectToAdvert(Long activityId, Integer activityType, Integer directStatus, Integer directMode, List<Long> advertIds) {
        try {
            return DubboResult.successResult((Object)this.activityAdvertService.activityDirectToAdvert(activityId, activityType, directStatus, directMode, advertIds));
        }
        catch (Exception e) {
            this.logger.error("RemoteActivityBackendService.activityDirectToAdvert is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<List<RspMaterialSpecificationDto>> getMsItemList() {
        try {
            return DubboResult.successResult(this.activityService.getMsItemList());
        }
        catch (Exception e) {
            this.logger.error("RemoteActivityBackendService.getMsItemList is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<List<RspActivityAdvertDto>> getAdvertByIds(List<Long> ids) {
        try {
            return DubboResult.successResult(this.advertService.getAdvertsByIds(ids));
        }
        catch (Exception e) {
            this.logger.error("RemoteActivityBackendService.getMsItemList is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<RspActivityDto> getActivityPlan(Long activityId, Integer activityType) {
        try {
            return DubboResult.successResult((Object)this.activityService.getActivityPlanDetail(activityId, activityType));
        }
        catch (Exception e) {
            this.logger.error("RemoteActivityBackendService.getActivityPlan is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<List<Long>> getActivityAdvertIds(Long activityId, Integer activityType) {
        try {
            return DubboResult.successResult(this.activityAdvertService.getActivityAdvertIds(activityId, activityType));
        }
        catch (Exception e) {
            this.logger.error("RemoteActivityBackendService.getActivityAdvertIds is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<ActivitySpmDto> getSlotActivitySpm(Long slotId, Long activityId, Integer activityType) {
        try {
            return DubboResult.successResult((Object)this.activitySpmService.getSlotActivitySpm(slotId, activityId, activityType));
        }
        catch (Exception e) {
            this.logger.error("RemoteActivityBackendService.getSlotActivitySpm is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<Boolean> removeFromNewActList(Long activityId, Integer activityType) {
        try {
            return DubboResult.successResult((Object)this.activityService.changeToOldAct(activityId, activityType));
        }
        catch (Exception e) {
            this.logger.error("RemoteActivityBackendService.removeFromNewActList is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }
}

