/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.remoteservice;

import cn.com.duiba.tuia.media.api.dto.ActivityManualPlanDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspActivityDto;
import cn.com.duiba.tuia.media.api.remoteservice.RemoteActivityManualBackendService;
import cn.com.duiba.tuia.media.dataobject.ActivityManualPlanDO;
import cn.com.duiba.tuia.media.remoteservice.BaseRemoteService;
import cn.com.duiba.tuia.media.service.ActivityManualService;
import cn.com.duiba.tuia.media.service.ActivityService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.time.DateUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RemoteActivityManualBackendServiceImpl
extends BaseRemoteService
implements RemoteActivityManualBackendService {
    private static final String TIME_DATE_FORMATE = "yyyy-MM-dd HH:mm";
    @Autowired
    private ActivityService activityService;
    @Autowired
    private ActivityManualService activityManualService;

    public DubboResult<Boolean> addActivityManualPlan(ActivityManualPlanDto planDto) {
        try {
            ActivityManualPlanDO plan = new ActivityManualPlanDO();
            BeanUtils.copyProperties((Object)planDto, (Object)plan);
            if (planDto.getReleaseTime() != null) {
                plan.setReleaseTime(DateUtils.parseDate((String)planDto.getReleaseTime(), (String[])new String[]{TIME_DATE_FORMATE}));
            }
            return DubboResult.successResult((Object)this.activityManualService.addActivityManualPlan(plan));
        }
        catch (Exception e) {
            this.logger.error("RemoteActivityManualServiceImpl.addActivityManualPlan is error, plan=" + planDto, (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<List<ActivityManualPlanDto>> findActivityManualPlans(Long slotId) {
        try {
            ArrayList<ActivityManualPlanDto> dtoList = new ArrayList<ActivityManualPlanDto>();
            List<ActivityManualPlanDO> list = this.activityManualService.findActivityManualPlans(slotId);
            for (ActivityManualPlanDO plan : list) {
                ActivityManualPlanDto planDto = new ActivityManualPlanDto();
                BeanUtils.copyProperties((Object)plan, (Object)planDto);
                if (plan.getReleaseTime() != null) {
                    planDto.setReleaseTime(new SimpleDateFormat(TIME_DATE_FORMATE).format(plan.getReleaseTime()));
                }
                if (0 == plan.getPlanType()) {
                    RspActivityDto activity = this.activityService.getActivityPlanDetail(plan.getActivityId(), plan.getActivityType());
                    planDto.setActivityName(activity.getName());
                    planDto.setActivityStatus(activity.getIsEnable());
                }
                if (1 == plan.getPlanType()) {
                    planDto.setActivityStatus(Integer.valueOf(1));
                }
                dtoList.add(planDto);
            }
            return DubboResult.successResult(dtoList);
        }
        catch (Exception e) {
            this.logger.error("RemoteActivityManualServiceImpl.findActivityManualPlans is error, slotId=" + slotId, (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<Boolean> modifyActivityManualPlan(ActivityManualPlanDto planDto) {
        try {
            ActivityManualPlanDO plan = new ActivityManualPlanDO();
            BeanUtils.copyProperties((Object)planDto, (Object)plan);
            if (planDto.getReleaseTime() != null) {
                plan.setReleaseTime(DateUtils.parseDate((String)planDto.getReleaseTime(), (String[])new String[]{TIME_DATE_FORMATE}));
            }
            return DubboResult.successResult((Object)this.activityManualService.modifyActivityManualPlan(plan));
        }
        catch (Exception e) {
            this.logger.error("RemoteActivityManualServiceImpl.modifyActivityManualPlan is error, planDto=" + planDto, (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<Boolean> removeActivityManualPlan(ActivityManualPlanDto planDto) {
        try {
            ActivityManualPlanDO plan = new ActivityManualPlanDO();
            BeanUtils.copyProperties((Object)planDto, (Object)plan);
            if (planDto.getReleaseTime() != null) {
                plan.setReleaseTime(DateUtils.parseDate((String)planDto.getReleaseTime(), (String[])new String[]{TIME_DATE_FORMATE}));
            }
            return DubboResult.successResult((Object)this.activityManualService.removeActivityManualPlan(plan));
        }
        catch (Exception e) {
            this.logger.error("RemoteActivityManualServiceImpl.removeActivityManualPlan is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }
}

