/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.service.cacheservice;

import cn.com.duiba.tuia.media.api.utils.CacheKeyUtils;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.wolf.redis.RedisClient;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class ActivityAdvertCacheService {
    @Autowired
    private RedisClient redisClient;

    public List<Long> get(Long activityId, Integer activityType) throws TuiaMediaException {
        String key = CacheKeyUtils.getActivityAdvertByKey((Long)activityId, (Integer)activityType);
        String value = this.redisClient.get(key);
        if (StringUtils.isEmpty((Object)value)) {
            return new ArrayList<Long>();
        }
        ArrayList<Long> advertIds = new ArrayList<Long>();
        for (String id : value.split(",")) {
            advertIds.add(Long.parseLong(id));
        }
        return advertIds;
    }

    public void set(Long activityId, Integer activityType, List<Long> advertIds) {
        String key = CacheKeyUtils.getActivityAdvertByKey((Long)activityId, (Integer)activityType);
        String value = Joiner.on((String)",").join(advertIds);
        this.redisClient.set(key, value);
    }
}

