/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.service.impl;

import cn.com.duiba.tuia.media.api.dto.MediaAppDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqActivityDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqIdAndType;
import cn.com.duiba.tuia.media.api.dto.req.ReqMaterialSpecificationDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspActivityDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspItemContentGroupDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspMaterialSpecificationDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspMaterialSpecificationItemDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspMsContentGroupDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspMsItemContentDto;
import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.common.utils.CollectionUtil;
import cn.com.duiba.tuia.media.dao.ActivityDAO;
import cn.com.duiba.tuia.media.dao.MaterialSpecificationItemContentDAO;
import cn.com.duiba.tuia.media.dataobject.ActivityManualPlanDO;
import cn.com.duiba.tuia.media.dataobject.MaterialSpecificationItemContentDO;
import cn.com.duiba.tuia.media.domain.ActivityDto;
import cn.com.duiba.tuia.media.parser.ActivityDtoParser;
import cn.com.duiba.tuia.media.service.ActivityManualService;
import cn.com.duiba.tuia.media.service.ActivityService;
import cn.com.duiba.tuia.media.service.ActivitySortService;
import cn.com.duiba.tuia.media.service.MaterialSpecificationService;
import cn.com.duiba.tuia.media.service.MediaAppService;
import cn.com.duiba.tuia.media.service.cacheservice.ActivityCacheService;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="activityService")
public class ActivityServiceImpl
implements ActivityService {
    @Autowired
    private ActivityDAO activityDAO;
    @Autowired
    private MaterialSpecificationItemContentDAO materialSpecificationItemContentDAO;
    @Autowired
    private ActivityCacheService activityCacheService;
    @Autowired
    private MaterialSpecificationService materialSpecificationService;
    @Autowired
    private ActivitySortService activitySortService;
    @Autowired
    private MediaAppService mediaAppService;
    @Autowired
    private ActivityManualService activityManualService;
    @Value(value="${media.activity.engine.url.prefix}")
    private String activityEngineUrlPrefix;

    @Override
    public List<RspActivityDto> getPlanList(ReqActivityDto req) throws TuiaMediaException {
        req.setSort("gmt_modified");
        req.setOrder("desc");
        req.setRowStart(req.getPageSize() * (req.getCurrentPage() - 1));
        List<ActivityDto> result = this.activityDAO.getList(req);
        ArrayList<RspActivityDto> list = new ArrayList<RspActivityDto>();
        for (ActivityDto activityDto : result) {
            RspActivityDto rspActivityDto = ActivityDtoParser.parseToRspActivityDto(activityDto);
            rspActivityDto.setItemContentAmount(Integer.valueOf(this.materialSpecificationItemContentDAO.itemContentAmount(rspActivityDto.getId(), rspActivityDto.getType())));
            list.add(rspActivityDto);
        }
        return list;
    }

    @Override
    public int getPlanListAmount(ReqActivityDto req) throws TuiaMediaException {
        return this.activityDAO.getListAmount(req);
    }

    @Override
    @Transactional
    public Boolean addActivityPlan(List<ReqIdAndType> activities) throws TuiaMediaException {
        for (ReqIdAndType idAndType : activities) {
            ActivityDto activityDto = new ActivityDto();
            activityDto.setActivityId(idAndType.getId());
            activityDto.setActivityType(idAndType.getType());
            activityDto.setDirectAdvertMode(1);
            activityDto.setIsPublish(1);
            this.activityDAO.update(activityDto);
        }
        return true;
    }

    @Override
    @Transactional
    public Boolean updateActivityPlan(ReqActivityDto reqActivityDto) throws TuiaMediaException {
        ActivityDto activityDto = new ActivityDto();
        activityDto.setActivityId(reqActivityDto.getId());
        activityDto.setActivityType(reqActivityDto.getType());
        activityDto.setActivityMsList(Joiner.on((String)",").appendTo(new StringBuilder(), (Iterable)reqActivityDto.getMsIdList()).toString());
        this.activityDAO.update(activityDto);
        List msContentList = reqActivityDto.getMsContentList();
        ArrayList<Long> needDeleteIds = new ArrayList<Long>();
        ArrayList<MaterialSpecificationItemContentDO> needAddList = new ArrayList<MaterialSpecificationItemContentDO>();
        List<Long> exitsMsIds = this.materialSpecificationItemContentDAO.selectMsIdsByActivity(reqActivityDto.getId(), reqActivityDto.getType());
        List newMsIds = CollectionUtil.getFieldList((List)msContentList, (String)"msId");
        for (Long msId : exitsMsIds) {
            if (newMsIds.contains(msId)) continue;
            this.materialSpecificationItemContentDAO.deleteByActivityAndMsId(reqActivityDto.getId(), reqActivityDto.getType(), msId);
        }
        for (RspMsContentGroupDto msContentGroupDto : msContentList) {
            List<MaterialSpecificationItemContentDO> msItemContentList = this.materialSpecificationItemContentDAO.selectByActivityAndMsId(reqActivityDto.getId(), reqActivityDto.getType(), msContentGroupDto.getMsId());
            List ids = CollectionUtil.getFieldList(msItemContentList, (String)"id");
            List itemContentList = msContentGroupDto.getItemContentGroupList();
            for (RspItemContentGroupDto itemContentGroupDto : itemContentList) {
                if (itemContentGroupDto.getId() != null) {
                    ids.remove(itemContentGroupDto.getId());
                    continue;
                }
                MaterialSpecificationItemContentDO materialSpecificationItemContentDO = new MaterialSpecificationItemContentDO();
                materialSpecificationItemContentDO.setMsId(msContentGroupDto.getMsId());
                materialSpecificationItemContentDO.setActivityId(reqActivityDto.getId());
                materialSpecificationItemContentDO.setActivityType(reqActivityDto.getType());
                ArrayList<String> contentList = new ArrayList<String>();
                for (RspMsItemContentDto msItemContentDto : itemContentGroupDto.getValue()) {
                    if (1 == msItemContentDto.getItemType()) {
                        contentList.add(msItemContentDto.getMsItemId() + "," + msItemContentDto.getImageUrl());
                        continue;
                    }
                    contentList.add(msItemContentDto.getMsItemId() + "," + msItemContentDto.getLetter());
                }
                StringBuilder sb = new StringBuilder();
                Joiner.on((String)";").appendTo(sb, contentList);
                materialSpecificationItemContentDO.setContent(sb.toString());
                needAddList.add(materialSpecificationItemContentDO);
            }
            needDeleteIds.addAll(ids);
        }
        this.materialSpecificationItemContentDAO.deleteBatch(needDeleteIds);
        this.materialSpecificationItemContentDAO.insertBatch(needAddList);
        return true;
    }

    @Override
    public RspActivityDto getActivityPlanDetail(Long activityId, Integer activityType) throws TuiaMediaException {
        ActivityDto activityDto = this.activityCacheService.get(activityId, activityType);
        if (activityDto == null) {
            activityDto = this.activityDAO.getDetail(activityId, activityType);
        }
        if (activityDto == null) {
            throw new TuiaMediaException(ErrorCode.E0501004);
        }
        return ActivityDtoParser.parseToRspActivityDto(activityDto);
    }

    @Override
    public Boolean changeActivityPlanEnable(Long activityId, Integer activityType, Integer enableStatus) throws TuiaMediaException {
        if (0 != enableStatus && 1 != enableStatus) {
            throw new TuiaMediaException(ErrorCode.E0001005);
        }
        ActivityDto activityDto = new ActivityDto();
        activityDto.setActivityId(activityId);
        activityDto.setActivityType(activityType);
        activityDto.setIsEnable(enableStatus);
        return this.activityDAO.update(activityDto) == 1;
    }

    @Override
    @Transactional
    public Boolean deleteActivityPlan(Long activityId, Integer activityType) throws TuiaMediaException {
        ActivityDto activityDto = new ActivityDto();
        activityDto.setActivityId(activityId);
        activityDto.setActivityType(activityType);
        activityDto.setIsPublish(0);
        this.activitySortService.deleteActivity(activityId, activityType, null);
        return this.activityDAO.update(activityDto) == 1;
    }

    @Override
    public List<RspActivityDto> getActivityByIds(List<Long> ids) throws TuiaMediaException {
        List<ActivityDto> result = this.activityDAO.getByIds(ids);
        ArrayList<RspActivityDto> list = new ArrayList<RspActivityDto>();
        for (ActivityDto activityDto : result) {
            list.add(ActivityDtoParser.parseToRspActivityDto(activityDto));
        }
        return list;
    }

    @Override
    public Boolean insertActivity(ActivityDto activityDto) throws TuiaMediaException {
        return this.activityDAO.insert(activityDto) == 1;
    }

    @Override
    public Boolean updateActivity(ActivityDto activityDto) throws TuiaMediaException {
        return this.activityDAO.update(activityDto) == 1;
    }

    @Override
    public Boolean deleteActivity(Long activityId, Integer activityType) throws TuiaMediaException {
        ActivityDto activityDto = new ActivityDto();
        activityDto.setActivityId(activityId);
        activityDto.setActivityType(activityType);
        activityDto.setIsDelete(1);
        return this.activityDAO.update(activityDto) == 1;
    }

    @Override
    public String getActivityName(Long activityId, Integer activityType) throws TuiaMediaException {
        ActivityDto activityDto = this.activityDAO.getDetail(activityId, activityType);
        if (activityDto != null) {
            return activityDto.getActivityName();
        }
        return null;
    }

    @Override
    public RspActivityDto getMsItemContent(RspActivityDto rspActivityDto) throws TuiaMediaException {
        if (rspActivityDto == null) {
            return null;
        }
        List msIds = rspActivityDto.getMsIdList();
        if (CollectionUtils.isEmpty((Collection)msIds)) {
            return rspActivityDto;
        }
        ArrayList<RspMaterialSpecificationDto> msItemContentList = new ArrayList<RspMaterialSpecificationDto>();
        Iterator iterator = msIds.iterator();
        while (iterator.hasNext()) {
            Long msId = (Long)iterator.next();
            RspMaterialSpecificationDto rspMaterialSpecificationDto = this.materialSpecificationService.getMaterialSpecificationDetail(msId);
            if (1 == rspMaterialSpecificationDto.getIsDelete()) {
                iterator.remove();
                continue;
            }
            HashMap<Long, RspMaterialSpecificationItemDto> msItemMap = new HashMap<Long, RspMaterialSpecificationItemDto>();
            for (RspMaterialSpecificationItemDto msItem : rspMaterialSpecificationDto.getItemDtoList()) {
                msItemMap.put(msItem.getId(), msItem);
            }
            List<MaterialSpecificationItemContentDO> list = this.materialSpecificationItemContentDAO.selectByActivityAndMsId(rspActivityDto.getId(), rspActivityDto.getType(), msId);
            if (!CollectionUtils.isEmpty(list)) {
                ArrayList<RspItemContentGroupDto> rspList = new ArrayList<RspItemContentGroupDto>();
                for (MaterialSpecificationItemContentDO itemContentDO : list) {
                    RspItemContentGroupDto itemContentGroup = new RspItemContentGroupDto();
                    itemContentGroup.setId(itemContentDO.getId());
                    itemContentGroup.setIsNewContent(itemContentDO.getIsNewContent());
                    itemContentGroup.setValue(this.analyzeContent(itemContentDO, msItemMap));
                    rspList.add(itemContentGroup);
                }
                rspMaterialSpecificationDto.setItemContentList(rspList);
            }
            msItemContentList.add(rspMaterialSpecificationDto);
        }
        rspActivityDto.setMsList(msItemContentList);
        return rspActivityDto;
    }

    private List<RspMsItemContentDto> analyzeContent(MaterialSpecificationItemContentDO itemContentDO, Map<Long, RspMaterialSpecificationItemDto> msItemMap) {
        ArrayList<RspMsItemContentDto> contentDtoList = new ArrayList<RspMsItemContentDto>();
        for (String content : itemContentDO.getContent().split(";")) {
            Long msItemId = Long.parseLong(content.split(",")[0]);
            RspMaterialSpecificationItemDto msItem = msItemMap.get(msItemId);
            if (msItem == null) continue;
            RspMsItemContentDto msItemContentDto = new RspMsItemContentDto();
            String string = content.split(",")[1];
            msItemContentDto.setItemType(msItem.getItemType());
            msItemContentDto.setImageWidth(msItem.getImageWidth());
            msItemContentDto.setImageHeight(msItem.getImageHeight());
            msItemContentDto.setDescription(msItem.getDescription());
            msItemContentDto.setMsItemId(msItemId);
            if (1 == msItem.getItemType()) {
                msItemContentDto.setImageUrl(string);
                contentDtoList.add(0, msItemContentDto);
            }
            if (2 != msItem.getItemType()) continue;
            msItemContentDto.setLetter(string);
            contentDtoList.add(msItemContentDto);
        }
        return contentDtoList;
    }

    @Override
    public List<Long> getIdsByName(String name) throws TuiaMediaException {
        return this.activityDAO.getIdsByName(name);
    }

    @Override
    public List<RspMaterialSpecificationDto> getMsItemList() throws TuiaMediaException {
        ReqMaterialSpecificationDto req = new ReqMaterialSpecificationDto();
        req.setSort("gmt_modified");
        req.setOrder("desc");
        req.setPageSize(Integer.valueOf(-1));
        List<RspMaterialSpecificationDto> list = this.materialSpecificationService.getMaterialSpecificationList(req);
        ArrayList<RspMaterialSpecificationDto> result = new ArrayList<RspMaterialSpecificationDto>();
        for (RspMaterialSpecificationDto ms : list) {
            result.add(this.materialSpecificationService.getMaterialSpecificationDetail(ms.getId()));
        }
        return result;
    }

    @Override
    public String getActivityUrl(Long activityAppId, Long adslotId) throws TuiaMediaException {
        ActivityManualPlanDO activityManual = this.activityManualService.findActivityManualPlan(adslotId);
        if (activityManual == null) {
            return null;
        }
        StringBuilder activityUrl = new StringBuilder();
        MediaAppDto app = this.mediaAppService.getMediaAppDto(activityAppId);
        if (app != null) {
            String appKey = app.getAppKey();
            activityUrl.append(this.activityEngineUrlPrefix).append("?appKey=").append(appKey).append("&adslotId=").append(adslotId);
        }
        return activityUrl.toString();
    }

    @Override
    public Boolean changeToOldAct(Long activityId, Integer activityType) throws TuiaMediaException {
        ActivityDto activityDto = new ActivityDto();
        activityDto.setActivityId(activityId);
        activityDto.setActivityType(activityType);
        activityDto.setIsNewAct(0);
        return this.updateActivity(activityDto);
    }

    @Override
    public Boolean refreshAllRedisActivity() throws TuiaMediaException {
        List<ActivityDto> list = this.activityDAO.getList(new ReqActivityDto());
        for (ActivityDto activityDto : list) {
            this.activityDAO.update(activityDto);
        }
        return true;
    }
}

