/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.dao.impl;

import cn.com.duiba.tuia.media.api.dto.req.ReqActivitySort;
import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.ActivitySortDAO;
import cn.com.duiba.tuia.media.dao.BaseDAO;
import cn.com.duiba.tuia.media.domain.ActivitySortDto;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Repository;

@Repository
public class ActivitySortDAOImpl
extends BaseDAO
implements ActivitySortDAO {
    @Override
    public int insertBatch(List<ActivitySortDto> activitySortDtoList) throws TuiaMediaException {
        try {
            if (CollectionUtils.isEmpty(activitySortDtoList)) {
                return 0;
            }
            return this.getSqlSession().insert(this.getStamentNameSpace("insertBatch"), activitySortDtoList);
        }
        catch (Exception e) {
            this.logger.error("ActivitySortDAO.insertBatch data happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public List<ActivitySortDto> selectByCondition(ReqActivitySort reqActivitySort) throws TuiaMediaException {
        try {
            return this.getSqlSession().selectList(this.getStamentNameSpace("selectByCondition"), (Object)reqActivitySort);
        }
        catch (Exception e) {
            this.logger.error("ActivitySortDAO.selectByCondition happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public int selectByConditionAmount(ReqActivitySort reqActivitySort) throws TuiaMediaException {
        try {
            return (Integer)this.getSqlSession().selectOne(this.getStamentNameSpace("selectByConditionAmount"), (Object)reqActivitySort);
        }
        catch (Exception e) {
            this.logger.error("ActivitySortDAO.selectByConditionAmount happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public int deleteAllSlotActivity(Long slotId) throws TuiaMediaException {
        try {
            return this.getSqlSession().delete(this.getStamentNameSpace("deleteAllSlotActivity"), (Object)slotId);
        }
        catch (Exception e) {
            this.logger.error("ActivitySortDAO.deleteAppAllActivity happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public int deleteActivity(Long slotId, Long activityId, Integer activityType) throws TuiaMediaException {
        try {
            HashMap<String, Number> map = new HashMap<String, Number>();
            map.put("slotId", slotId);
            map.put("activityId", activityId);
            map.put("activityType", activityType);
            return this.getSqlSession().delete(this.getStamentNameSpace("deleteActivity"), map);
        }
        catch (Exception e) {
            this.logger.error("ActivitySortDAO.deleteActivity happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public List<ActivitySortDto> getActivityForRecommendByApp(Long appId) throws TuiaMediaException {
        try {
            return this.getSqlSession().selectList(this.getStamentNameSpace("getActivityForRecommendByApp"), (Object)appId);
        }
        catch (Exception e) {
            this.logger.error("ActivitySortDAO.getActivityForRecommendByApp happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public List<ActivitySortDto> getActivityForRecommendBySlot(Long slotId) throws TuiaMediaException {
        try {
            return this.getSqlSession().selectList(this.getStamentNameSpace("getActivityForRecommendBySlotId"), (Object)slotId);
        }
        catch (Exception e) {
            this.logger.error("ActivitySortDAO.getActivityForRecommendBySlot happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public int updateSort(Long slotId, Long activityId, Integer activityType, int sort) throws TuiaMediaException {
        try {
            HashMap<String, Number> params = new HashMap<String, Number>();
            params.put("activitySlotId", slotId);
            params.put("activityId", activityId);
            params.put("activityType", activityType);
            params.put("absoluteSort", sort);
            return this.getSqlSession().update(this.getStamentNameSpace("updateSort"), params);
        }
        catch (Exception e) {
            this.logger.error("ActivitySortDAO.updateSort happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public List<ActivitySortDto> getAllActivityBySlotId(Long slotId) throws TuiaMediaException {
        try {
            return this.getSqlSession().selectList(this.getStamentNameSpace("getAllActivityBySlotId"), (Object)slotId);
        }
        catch (Exception e) {
            this.logger.error("ActivitySortDAO.getAllActivityBySlotId happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public int updateSortBatch(Long slotId, int startLocation, int endLocation, int step) throws TuiaMediaException {
        try {
            HashMap<String, Number> map = new HashMap<String, Number>();
            map.put("slotId", slotId);
            map.put("startLocation", startLocation);
            map.put("endLocation", endLocation);
            map.put("step", step);
            return this.getSqlSession().update(this.getStamentNameSpace("updateSortBatch"), map);
        }
        catch (Exception e) {
            this.logger.error("ActivitySortDAO.updateSortBatch happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public List<ActivitySortDto> selectBySlot(Long slotId) throws TuiaMediaException {
        try {
            return this.getSqlSession().selectList(this.getStamentNameSpace("selectBySlot"), (Object)slotId);
        }
        catch (Exception e) {
            this.logger.error("ActivitySortDAO.selectBySlot happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }
}

