/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.dao.impl;

import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.BaseDAO;
import cn.com.duiba.tuia.media.dao.ShieldStrategyDAO;
import cn.com.duiba.tuia.media.domain.ShieldStrategyDto;
import cn.com.duiba.tuia.media.model.req.ReqStrategyPageQuery;
import java.util.HashMap;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository
public class ShieldStrategyDAOImpl
extends BaseDAO
implements ShieldStrategyDAO {
    @Override
    public int insert(ShieldStrategyDto strategyDto) throws TuiaMediaException {
        try {
            return this.getSqlSession().insert(this.getStamentNameSpace("insert"), (Object)strategyDto);
        }
        catch (Exception e) {
            this.logger.error("ShieldStrategyDAO.insert happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public int updateByManager(ShieldStrategyDto strategyDto) throws TuiaMediaException {
        try {
            return this.getSqlSession().update(this.getStamentNameSpace("updateByManager"), (Object)strategyDto);
        }
        catch (Exception e) {
            this.logger.error("ShieldStrategyDAO.updateByManager happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public int update(ShieldStrategyDto strategyDto) throws TuiaMediaException {
        try {
            return this.getSqlSession().update(this.getStamentNameSpace("update"), (Object)strategyDto);
        }
        catch (Exception e) {
            this.logger.error("ShieldStrategyDAO.update happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public int delete(Long id) throws TuiaMediaException {
        try {
            return this.getSqlSession().delete(this.getStamentNameSpace("delete"), (Object)id);
        }
        catch (Exception e) {
            this.logger.error("ShieldStrategyDAO.delete happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public List<ShieldStrategyDto> selectListByMediaId(Long mediaId) throws TuiaMediaException {
        try {
            return this.getSqlSession().selectList(this.getStamentNameSpace("selectListByMediaId"), (Object)mediaId);
        }
        catch (Exception e) {
            this.logger.error("ShieldStrategyDAO.selectListByMediaId happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public ShieldStrategyDto selectById(Long id) throws TuiaMediaException {
        try {
            return (ShieldStrategyDto)((Object)this.getSqlSession().selectOne(this.getStamentNameSpace("selectById"), (Object)id));
        }
        catch (Exception e) {
            this.logger.error("ShieldStrategyDAO.selectById happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public List<ShieldStrategyDto> selectListByPage(ReqStrategyPageQuery req) throws TuiaMediaException {
        try {
            return this.getSqlSession().selectList(this.getStamentNameSpace("selectListByPage"), (Object)req);
        }
        catch (Exception e) {
            this.logger.error("ShieldStrategyDAO.selectListByPage happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public int selectAmountByPage(ReqStrategyPageQuery req) throws TuiaMediaException {
        try {
            return (Integer)this.getSqlSession().selectOne(this.getStamentNameSpace("selectAmountByPage"), (Object)req);
        }
        catch (Exception e) {
            this.logger.error("ShieldStrategyDAO.selectAmountByPage happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public boolean isNotExist(Long id, Long mediaId, String name) throws TuiaMediaException {
        Long strategyId = null;
        try {
            HashMap<String, Object> param = new HashMap<String, Object>(2);
            param.put("mediaId", mediaId);
            param.put("strategyName", name);
            strategyId = (Long)this.getSqlSession().selectOne(this.getStamentNameSpace("selectIdByName"), param);
        }
        catch (Exception e) {
            this.logger.error("ShieldStrategyDAO.selectIdByName happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
        if (strategyId != null && (id == null || strategyId.longValue() != id.longValue())) {
            throw new TuiaMediaException(ErrorCode.E0304003);
        }
        return true;
    }

    @Override
    public List<Long> selectAllIds() throws TuiaMediaException {
        try {
            return this.getSqlSession().selectList(this.getStamentNameSpace("selectAllIds"));
        }
        catch (Exception e) {
            this.logger.error("SlotStatisticsDAOImpl.selectAllIds data happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }
}

