/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.remoteservice;

import cn.com.duiba.tuia.activity.center.api.dto.ActivityType;
import cn.com.duiba.tuia.activity.center.api.remoteservice.RemoteActivityService;
import cn.com.duiba.tuia.media.api.dto.PageResultDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqActivitySort;
import cn.com.duiba.tuia.media.api.dto.req.ReqIdAndType;
import cn.com.duiba.tuia.media.api.dto.rsp.RspActivityDto;
import cn.com.duiba.tuia.media.api.remoteservice.RemoteActivitySortBackendService;
import cn.com.duiba.tuia.media.dao.MaterialSpecificationItemContentDAO;
import cn.com.duiba.tuia.media.domain.ActivitySortDto;
import cn.com.duiba.tuia.media.remoteservice.BaseRemoteService;
import cn.com.duiba.tuia.media.service.ActivityService;
import cn.com.duiba.tuia.media.service.ActivitySortService;
import cn.com.duiba.tuia.media.service.ActivitySpmService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class RemoteActivitySortBackendServiceImpl
extends BaseRemoteService
implements RemoteActivitySortBackendService {
    @Autowired
    private ActivityService activityService;
    @Autowired
    private ActivitySortService activitySortService;
    @Autowired
    private ActivitySpmService activitySpmService;
    @Autowired
    private RemoteActivityService remoteActivityService;
    @Autowired
    private MaterialSpecificationItemContentDAO materialSpecificationItemContentDAO;

    public DubboResult<PageResultDto<RspActivityDto>> getByCondition(ReqActivitySort reqActivitySort) {
        try {
            DubboResult selectResult = this.remoteActivityService.selectAllActivityType();
            HashMap<Integer, String> actTypeMap = new HashMap<Integer, String>();
            List actTypeList = (List)selectResult.getResult();
            for (ActivityType actType : actTypeList) {
                actTypeMap.put(actType.getId(), actType.getName());
            }
            int amount = this.activitySortService.selectByConditionAmount(reqActivitySort);
            reqActivitySort.setSort("activity_sort asc,gmt_modified desc");
            reqActivitySort.setRowStart(reqActivitySort.getPageSize() * (reqActivitySort.getCurrentPage() - 1));
            List<ActivitySortDto> result = this.activitySortService.selectByCondition(reqActivitySort);
            ArrayList<RspActivityDto> list = new ArrayList<RspActivityDto>();
            for (ActivitySortDto activitySortDto : result) {
                RspActivityDto dto = this.activityService.getActivityPlanDetail(activitySortDto.getActivityId(), activitySortDto.getActivityType());
                if (dto == null) continue;
                if (1 == dto.getSource()) {
                    dto.setTypeName((String)actTypeMap.get(dto.getType()));
                }
                dto.setItemContentAmount(Integer.valueOf(this.materialSpecificationItemContentDAO.itemContentAmount(dto.getId(), dto.getType())));
                dto.setIndex(activitySortDto.getAbsoluteSort());
                list.add(dto);
            }
            return DubboResult.successResult((Object)new PageResultDto(amount, list, reqActivitySort.getPageSize().intValue()));
        }
        catch (Exception e) {
            this.logger.error("RemoteActivitySortBackendService.getByCondition is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<Boolean> addActivitySort(Long slotId, List<ReqIdAndType> idAndTypes) {
        try {
            DubboResult result = new DubboResult();
            result.setSuccess(true);
            result.setReturnCode("0");
            int successRecord = this.activitySortService.addActivitySort(slotId, idAndTypes);
            result.setMsg("\u6210\u529f\u6dfb\u52a0" + successRecord + "\u4e2a\u6d3b\u52a8");
            return result;
        }
        catch (Exception e) {
            this.logger.error("RemoteActivitySortBackendService.addActivitySort is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<Boolean> addDefaultActivitySort(Long slotId) {
        try {
            DubboResult result = new DubboResult();
            result.setSuccess(true);
            result.setReturnCode("0");
            int successRecord = this.activitySortService.addDefaultActivitySort(slotId);
            result.setMsg("\u6210\u529f\u6dfb\u52a0" + successRecord + "\u4e2a\u6d3b\u52a8");
            return result;
        }
        catch (Exception e) {
            this.logger.error("RemoteActivitySortBackendService.addDefaultActivitySort is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<Boolean> removeActivity(Long slotId, Long activityId, Integer activityType) {
        try {
            return DubboResult.successResult((Object)this.activitySortService.deleteActivity(activityId, activityType, slotId));
        }
        catch (Exception e) {
            this.logger.error("RemoteActivitySortBackendService.removeActivity is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<Boolean> sort(Long slotId, Long activityId, Integer activityType, int location) {
        try {
            return DubboResult.successResult((Object)this.activitySortService.sortActivity(slotId, activityId, activityType, location));
        }
        catch (Exception e) {
            this.logger.error("RemoteActivitySortBackendService.sort is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<List<RspActivityDto>> getActivityByApp(Long appId) {
        try {
            return DubboResult.successResult(this.activitySortService.getActivityForRecommendByApp(appId));
        }
        catch (Exception e) {
            this.logger.error("RemoteActivitySortBackendService.getActivityByApp is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<List<RspActivityDto>> getActivityBySlotNew(Long slotId) {
        try {
            return DubboResult.successResult(this.activitySortService.getActivityForRecommendBySlot(slotId));
        }
        catch (Exception e) {
            this.logger.error("RemoteActivitySortBackendService.getActivityBySlotNew is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<List<RspActivityDto>> getActivityForCenter(Long slotId) {
        try {
            return DubboResult.successResult(this.activitySortService.getActivityForCenter(slotId));
        }
        catch (Exception e) {
            this.logger.error("RemoteActivitySortBackendService.getActivityBySlot is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<List<Long>> getActivityIdForCenter(int count) {
        try {
            return DubboResult.successResult(this.activitySpmService.getTuiaActivityIdList(count));
        }
        catch (Exception e) {
            this.logger.error("RemoteActivitySortBackendService.getActivityIdForCenter is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<List<RspActivityDto>> getEngineActivityList() {
        try {
            return DubboResult.successResult(this.activitySortService.getEngineActivityList());
        }
        catch (Exception e) {
            this.logger.error("RemoteActivitySortBackendService.getEngineActivityList is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<List<RspActivityDto>> getNewActivityList() {
        try {
            return DubboResult.successResult(this.activitySortService.getNewActivityList());
        }
        catch (Exception e) {
            this.logger.error("RemoteActivitySortBackendService.getNewActivityList is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<List<RspActivityDto>> getDefaultActivityList() {
        try {
            return DubboResult.successResult(this.activitySortService.getDefaultActivityList());
        }
        catch (Exception e) {
            this.logger.error("RemoteActivitySortBackendService.getDefaultActivityList is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<List<RspActivityDto>> getActivityPlanDetailList(List<Long> ids) {
        try {
            List<RspActivityDto> activityList = this.activityService.getActivityByIds(ids, null);
            for (RspActivityDto activityDto : activityList) {
                this.activityService.getMsItemContent(activityDto);
            }
            return DubboResult.successResult(activityList);
        }
        catch (Exception e) {
            this.logger.error("RemoteActivitySortBackendService.getActivityPlanDetailList is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }
}

