/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.remoteservice;

import cn.com.duiba.tuia.media.api.dto.MediaAppDataDto;
import cn.com.duiba.tuia.media.api.dto.MediaAppDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqUpdateMediaAppStatusDto;
import cn.com.duiba.tuia.media.api.remoteservice.RemoteMediaAppBackendService;
import cn.com.duiba.tuia.media.model.IdAndName;
import cn.com.duiba.tuia.media.parser.IdAndNameParser;
import cn.com.duiba.tuia.media.remoteservice.BaseRemoteService;
import cn.com.duiba.tuia.media.service.MediaAppService;
import cn.com.duiba.tuia.media.service.impl.MediaCacheService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class RemoteMediaAppBackendServiceImpl
extends BaseRemoteService
implements RemoteMediaAppBackendService {
    @Autowired
    MediaAppService mediaAppService;
    @Autowired
    MediaCacheService mediaCacheService;

    public DubboResult<Boolean> updateMediaAppStatus(ReqUpdateMediaAppStatusDto param) {
        try {
            return DubboResult.successResult((Object)this.mediaAppService.updateMediaAppStatus(param));
        }
        catch (Exception e) {
            this.logger.error("RemoteMediaAppBackendServiceImpl.updateMediaAppStatus is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<MediaAppDto> getMediaApp(Long appId) {
        try {
            return DubboResult.successResult((Object)this.mediaAppService.getMediaAppDto(appId));
        }
        catch (Exception e) {
            this.logger.error("RemoteMediaAppBackendServiceImpl.getMediaApp is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<Boolean> getAllAppIdAndName() {
        try {
            return DubboResult.successResult((Object)this.mediaAppService.selectAllAppIdAndName());
        }
        catch (Exception e) {
            this.logger.error("RemoteMediaAppBackendServiceImpl.setAllAppIdAndName is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<Boolean> delAllAppIdAndName() {
        try {
            return DubboResult.successResult((Object)this.mediaAppService.delAllAppIdAndName());
        }
        catch (Exception e) {
            this.logger.error("RemoteMediaAppBackendServiceImpl.delAllAppIdAndName is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<List<Long>> getAppIdsByName(String name) {
        try {
            return DubboResult.successResult(this.mediaAppService.selectIdsByName(name));
        }
        catch (Exception e) {
            this.logger.error("RemoteMediaAppBackendServiceImpl.getAppIdsByName is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<String> getAppNameById(Long appId) {
        try {
            return DubboResult.successResult((Object)this.mediaAppService.selectAppNameById(appId));
        }
        catch (Exception e) {
            this.logger.error("RemoteMediaAppBackendServiceImpl.getAppNameById is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<List<MediaAppDto>> getMediaAppByIds(List<Long> ids) {
        try {
            List<IdAndName> list = this.mediaAppService.selectAppIdAndName(ids);
            ArrayList<MediaAppDto> result = new ArrayList<MediaAppDto>();
            for (IdAndName idAndName : list) {
                result.add(IdAndNameParser.parseToMediaAppDto(idAndName));
            }
            return DubboResult.successResult(result);
        }
        catch (Exception e) {
            this.logger.error("RemoteMediaAppBackendServiceImpl.getMediaApp is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<MediaAppDataDto> getMediaAppCacheById(Long appId) {
        try {
            return DubboResult.successResult((Object)this.mediaCacheService.getMediaApp(appId));
        }
        catch (Exception e) {
            this.logger.error("RemoteMediaAppBackendServiceImpl.getMediaAppCacheById is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }
}

