/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.remoteservice;

import cn.com.duiba.tuia.media.api.dto.PageResultDto;
import cn.com.duiba.tuia.media.api.dto.SlotCacheDto;
import cn.com.duiba.tuia.media.api.dto.SlotConfigDto;
import cn.com.duiba.tuia.media.api.dto.SlotDto;
import cn.com.duiba.tuia.media.api.dto.SlotTypeParamDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqGetSlotsByPageDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqUpdateSlotStrategy;
import cn.com.duiba.tuia.media.api.dto.rsp.RspAdsenseSlotListDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspSlotBackendDetailDto;
import cn.com.duiba.tuia.media.api.remoteservice.RemoteSlotBackendService;
import cn.com.duiba.tuia.media.bo.SlotBackendBo;
import cn.com.duiba.tuia.media.remoteservice.BaseRemoteService;
import cn.com.duiba.tuia.media.service.SlotService;
import cn.com.duiba.tuia.media.service.impl.SlotCacheService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class RemoteSlotBackendServiceImpl
extends BaseRemoteService
implements RemoteSlotBackendService {
    @Autowired
    private SlotService slotService;
    @Autowired
    private SlotCacheService slotCacheService;
    @Autowired
    private SlotBackendBo slotBackendBo;

    public DubboResult<RspSlotBackendDetailDto> getDetail(long slotId) {
        try {
            return DubboResult.successResult((Object)this.slotBackendBo.getBackendSlotDetailById(slotId));
        }
        catch (Exception e) {
            this.logger.error("RemoteSlotBackendService.getDetail is error");
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<PageResultDto<RspAdsenseSlotListDto>> getSlotsByPage(ReqGetSlotsByPageDto req) {
        try {
            return DubboResult.successResult(this.slotService.selectAdsenseListByPage(req));
        }
        catch (Exception e) {
            this.logger.error("RemoteSlotBackendService.getSlotsByPage is error");
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<Boolean> batchUpdateCheckStatus(List<Long> slotIds, int status) {
        try {
            return DubboResult.successResult((Object)this.slotBackendBo.batchUpdateCheckStatus(slotIds, status));
        }
        catch (Exception e) {
            this.logger.error("RemoteSlotBackendService.batchUpdateCheckStatus is error");
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<List<SlotDto>> getListDetail(List<Long> slotIds) {
        try {
            return DubboResult.successResult(this.slotService.getListDetail(slotIds));
        }
        catch (Exception e) {
            this.logger.error("RemoteSlotBackendService.getListDetail is error");
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<Boolean> update(ReqUpdateSlotStrategy param) {
        try {
            return DubboResult.successResult((Object)this.slotBackendBo.updateSlotStrategy(param));
        }
        catch (Exception e) {
            this.logger.error("RemoteSlotBackendService.update is error");
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<List<SlotTypeParamDto>> selectSlotTypeParam() {
        try {
            return DubboResult.successResult(this.slotBackendBo.buildSoltTypeParam());
        }
        catch (Exception e) {
            this.logger.error("RemoteSlotBackendService.update is error");
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<Boolean> updateSlot(SlotDto slotDto) {
        try {
            return DubboResult.successResult((Object)this.slotService.updateSlot(slotDto));
        }
        catch (Exception e) {
            this.logger.error("RemoteSlotBackendService.updateSlot is error");
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<List<Long>> getSlotIdsByName(String slotName) {
        try {
            return DubboResult.successResult(this.slotService.selectIdsByName(slotName));
        }
        catch (Exception e) {
            this.logger.error("RemoteSlotBackendService.getSlotIdsByName is error");
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<Boolean> getAllSlotIdAndNameCache() {
        try {
            return DubboResult.successResult((Object)this.slotCacheService.getSlotIdAndNameCache());
        }
        catch (Exception e) {
            this.logger.error("RemoteSlotBackendService.getAllSlotIdAndNameCache is error");
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<Boolean> delAllSlotIdAndNameCache() {
        try {
            return DubboResult.successResult((Object)this.slotCacheService.delSlotIdAndNameCache());
        }
        catch (Exception e) {
            this.logger.error("RemoteSlotBackendService.delAllSlotIdAndNameCache is error");
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<SlotDto> getSlotById(Long slotId) {
        try {
            return DubboResult.successResult((Object)this.slotService.selectById(slotId));
        }
        catch (Exception e) {
            this.logger.error("RemoteSlotBackendService.getSlotById is error");
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<SlotCacheDto> getSlotByIdCache(Long slotId) {
        try {
            return DubboResult.successResult((Object)this.slotCacheService.getSlot(slotId));
        }
        catch (Exception e) {
            this.logger.error("RemoteSlotBackendService.getSlotById is error");
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<List<SlotDto>> selectSlotByAppId(Long appId) {
        try {
            return DubboResult.successResult(this.slotService.selectSlotByAppId(appId));
        }
        catch (Exception e) {
            this.logger.error("RemoteSlotBackendService.selectSlotByAppId is error");
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<List<SlotConfigDto>> selectSlotConfigListByAppId(Long appId) {
        try {
            return DubboResult.successResult(this.slotService.selectSlotConfigListByAppId(appId));
        }
        catch (Exception e) {
            this.logger.error("RemoteSlotBackendService.selectSlotConfigListByAppId is error");
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<Boolean> updateSlotConfig(SlotConfigDto dto) {
        try {
            SlotConfigDto slotConfigDto = this.slotService.selectSlotConfigBySlotId(dto.getSlotId());
            if (slotConfigDto == null) {
                this.slotService.insertSlotConfig(dto);
            } else {
                this.slotService.updateSlotConfig(dto);
            }
            return DubboResult.successResult((Object)true);
        }
        catch (Exception e) {
            this.logger.error("RemoteSlotBackendService.updateSlotConfig is error");
            return this.exceptionFailure(e);
        }
    }
}

