/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.service.cacheservice;

import cn.com.duiba.tuia.media.api.utils.CacheKeyUtils;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.domain.ActivityDto;
import cn.com.duiba.tuia.media.utils.JsonUtils;
import cn.com.duiba.wolf.redis.RedisClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class ActivityCacheService {
    @Autowired
    private RedisClient redisClient;
    private Logger logger = LoggerFactory.getLogger(ActivityCacheService.class);

    public ActivityDto get(Long activityId, Integer activityType) throws TuiaMediaException {
        String key = CacheKeyUtils.getActivityByKey((String)(activityId + "-" + activityType));
        String value = this.redisClient.get(key);
        if (StringUtils.isEmpty((Object)value)) {
            return null;
        }
        try {
            return JsonUtils.jsonToObject(ActivityDto.class, value);
        }
        catch (Exception e) {
            this.logger.info(" CacheKeyUtils.getActivityByKey JsonUtils.jsonToObject error", (Throwable)e);
            return null;
        }
    }

    public void set(ActivityDto activityDto) throws TuiaMediaException {
        String key = CacheKeyUtils.getActivityByKey((String)(activityDto.getActivityId() + "-" + activityDto.getActivityType()));
        String value = JsonUtils.objectToString((Object)activityDto);
        this.redisClient.set(key, value);
    }
}

