/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.service.impl;

import cn.com.duiba.tuia.media.api.dto.AccountChangeDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqAccountChange;
import cn.com.duiba.tuia.media.api.dto.rsp.AccountChangeRsp;
import cn.com.duiba.tuia.media.api.dto.rsp.RspAccountChangeResult;
import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.common.tool.DataTool;
import cn.com.duiba.tuia.media.dao.AccountChangeDAO;
import cn.com.duiba.tuia.media.service.AccountChangeService;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.ListUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AccountChangeServiceImpl
implements AccountChangeService {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String WORD_SEPARATOR = "\",\"";
    private static final String START_PREFIX = "\" ";
    private static final String END_POSTFIX = "\"\n";
    @Autowired
    private AccountChangeDAO accountChangeDAO;

    @Override
    public RspAccountChangeResult<AccountChangeRsp> selectAccountChangeByPage(ReqAccountChange req) throws TuiaMediaException {
        int row = this.accountChangeDAO.selectAccountChangeCount(req);
        List<AccountChangeDto> accountChangeDtos = null;
        List<AccountChangeRsp> accountChangeRsps = new ArrayList();
        Long balance = 0L;
        if (row > 0 && row >= req.getRowStart()) {
            req.setRowStart(req.getPageSize() * (req.getCurrentPage() - 1));
            accountChangeDtos = this.accountChangeDAO.selectAccountChangeByPage(req);
            balance = this.accountChangeDAO.selectAccountBalance(req.getMediaId());
        }
        if (CollectionUtils.isNotEmpty(accountChangeDtos)) {
            for (AccountChangeDto dto : accountChangeDtos) {
                AccountChangeRsp rsp = new AccountChangeRsp();
                rsp.setAmount(dto.getAmount());
                rsp.setBalance(dto.getBalance());
                rsp.setChangeType(dto.getChangeType());
                rsp.setNote(dto.getRemark());
                rsp.setCurrentDate(new DateTime((Object)dto.getCurDate()).toString("yyyy-MM-dd HH:mm:ss"));
                accountChangeRsps.add(rsp);
            }
        } else {
            accountChangeRsps = ListUtils.EMPTY_LIST;
        }
        return new RspAccountChangeResult(row, accountChangeRsps, req.getPageSize().intValue(), balance);
    }

    @Override
    public void insertAccountChange(AccountChangeDto accountChangeDto) throws TuiaMediaException {
        this.accountChangeDAO.insertAccountChange(accountChangeDto);
    }

    @Override
    public List<AccountChangeDto> selectAccountChangeListByIds(List<Long> ids) throws TuiaMediaException {
        return this.accountChangeDAO.selectAccountChangeListByIds(ids);
    }

    @Override
    public AccountChangeDto selectAccountChangeById(Long id) throws TuiaMediaException {
        return this.accountChangeDAO.selectAccountChangeById(id);
    }

    @Override
    public AccountChangeDto selectAccountChangeByMediaId(Long mediaId) throws TuiaMediaException {
        return this.accountChangeDAO.selectAccountChangeByMediaId(mediaId);
    }

    @Override
    public List<AccountChangeDto> selectAccountChangeList(ReqAccountChange req) throws TuiaMediaException {
        return this.accountChangeDAO.selectAccountChangeList(req);
    }

    @Override
    public void exportAccountChange(ReqAccountChange req, OutputStream out) throws TuiaMediaException {
        StringBuilder content = new StringBuilder();
        content.append(" \u65f6\u95f4 ,\u660e\u7ec6,\u91d1\u989d\uff08\u5143\uff09,\u4f59\u989d\uff08\u5143\uff09\n");
        try {
            List<AccountChangeDto> datas = this.accountChangeDAO.selectAccountChangeList(req);
            if (CollectionUtils.isNotEmpty(datas)) {
                for (AccountChangeDto data : datas) {
                    StringBuilder row = new StringBuilder();
                    row.append(START_PREFIX);
                    row.append(new DateTime((Object)data.getCurDate()).toString("yyyy-MM-dd HH:mm:ss"));
                    row.append(WORD_SEPARATOR);
                    row.append(data.getRemark());
                    row.append(WORD_SEPARATOR);
                    row.append("+" + DataTool.calculateFenToYuan((Long)data.getAmount()));
                    row.append(WORD_SEPARATOR);
                    row.append(DataTool.calculateFenToYuan((Long)data.getBalance()));
                    row.append(END_POSTFIX);
                    content.append((CharSequence)row);
                }
            }
            this.doExportFile(out, content);
        }
        catch (TuiaMediaException e) {
            this.logger.error("exportAccountChange error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002006);
        }
    }

    private void doExportFile(OutputStream out, StringBuilder content) throws TuiaMediaException {
        try {
            out.write(content.toString().getBytes("GBK"));
            out.flush();
        }
        catch (Exception e) {
            this.logger.error("doExportFile error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002006, (Throwable)e);
        }
    }
}

