/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.service.impl;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.RemoteGoodsCouponBackendService;
import cn.com.duiba.goods.center.api.remoteservice.dto.ACGStockDto;
import cn.com.duiba.tuia.core.api.dto.AdvertDetailDto;
import cn.com.duiba.tuia.core.api.dto.AdvertDto;
import cn.com.duiba.tuia.core.api.remoteservice.RemoteAdvertBackendService;
import cn.com.duiba.tuia.media.api.constant.AdvertValidStatusConstant;
import cn.com.duiba.tuia.media.api.dto.rsp.RspActivityAdvertDto;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.service.AdvertService;
import cn.com.duiba.tuia.media.service.BaseService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AdvertServiceImpl
extends BaseService
implements AdvertService {
    @Autowired
    private RemoteAdvertBackendService remoteAdvertBackendService;
    @Autowired
    private RemoteGoodsCouponBackendService remoteGoodsCouponBackendService;

    @Override
    public Map<Long, AdvertDto> getAdvertListByIds(List<Long> advertIds) throws TuiaMediaException {
        DubboResult result = this.remoteAdvertBackendService.getAdvertsByIds(advertIds);
        this.doTuiaMediaException(result, "AdvertService.getAdvertListByIds");
        HashMap<Long, AdvertDto> map = new HashMap<Long, AdvertDto>();
        if (result.getResult() != null) {
            for (AdvertDto advertDto : (List)result.getResult()) {
                map.put(advertDto.getId(), advertDto);
            }
        }
        return map;
    }

    @Override
    public AdvertDetailDto getAdvertDetailById(Long advertId) {
        DubboResult result = this.remoteAdvertBackendService.getAdvertDetailById(advertId.longValue());
        return (AdvertDetailDto)result.getResult();
    }

    @Override
    public ACGStockDto findGoodsStock(Long couponId) {
        DubboResult result = this.remoteGoodsCouponBackendService.findGoodsStock(GoodsTypeEnum.ADVERT, couponId);
        return (ACGStockDto)result.getResult();
    }

    @Override
    public List<RspActivityAdvertDto> getAdvertsByIds(List<Long> ids) throws TuiaMediaException {
        ArrayList<RspActivityAdvertDto> result = new ArrayList<RspActivityAdvertDto>();
        if (!CollectionUtils.isEmpty(ids)) {
            Map<Long, AdvertDto> map = this.getAdvertListByIds(ids);
            for (Long id : ids) {
                AdvertDto advertDto = map.get(id);
                if (advertDto == null || 0 != advertDto.getSource()) continue;
                RspActivityAdvertDto rspActivityAdvertDto = new RspActivityAdvertDto();
                rspActivityAdvertDto.setId(advertDto.getId());
                rspActivityAdvertDto.setName(advertDto.getName());
                rspActivityAdvertDto.setStatus(advertDto.getValidStatus());
                rspActivityAdvertDto.setStatusText(AdvertValidStatusConstant.getValidStatusText((Integer)advertDto.getValidStatus()));
                AdvertDetailDto advertDetailDto = this.getAdvertDetailById(id);
                if (advertDetailDto != null) {
                    ACGStockDto acgStockDto;
                    rspActivityAdvertDto.setCompanyName(advertDetailDto.getAdvertiserName());
                    if (advertDetailDto.getAdvertCoupon() != null && (acgStockDto = this.findGoodsStock(advertDetailDto.getAdvertCoupon().getId())) != null) {
                        rspActivityAdvertDto.setInitInventory(acgStockDto.getTotalStock());
                        rspActivityAdvertDto.setCurInventory(acgStockDto.getStock());
                    }
                }
                result.add(rspActivityAdvertDto);
            }
        }
        return result;
    }
}

