/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.service.impl;

import cn.com.duiba.activity.center.api.dto.activity.AppDirectDto;
import cn.com.duiba.activity.center.api.remoteservice.activity.RemoteAppDirectService;
import cn.com.duiba.developer.center.api.domain.dto.AppSimpleDto;
import cn.com.duiba.developer.center.api.domain.paramquery.CreateAppQueryParams;
import cn.com.duiba.developer.center.api.remoteservice.RemoteAppService;
import cn.com.duiba.tuia.core.api.dto.AppDto;
import cn.com.duiba.tuia.core.api.remoteservice.RemoteAppBackendService;
import cn.com.duiba.tuia.media.api.dto.AccountDto;
import cn.com.duiba.tuia.media.api.dto.MediaAppCheckRecordDto;
import cn.com.duiba.tuia.media.api.dto.MediaAppConfigDto;
import cn.com.duiba.tuia.media.api.dto.MediaAppDto;
import cn.com.duiba.tuia.media.api.dto.PageResultDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqCreatMediaAppDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqCreateMediaAppConfigDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqUpdateMediaAppStatusDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspAppInnerLogDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspBaseInnerLogDto;
import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.common.utils.BlowfishUtils;
import cn.com.duiba.tuia.media.dao.AccountDAO;
import cn.com.duiba.tuia.media.dao.MediaAppCheckRecordDao;
import cn.com.duiba.tuia.media.dao.MediaAppConfigDao;
import cn.com.duiba.tuia.media.dao.MediaAppDao;
import cn.com.duiba.tuia.media.model.IdAndName;
import cn.com.duiba.tuia.media.model.req.ReqPageQueryMediaApp;
import cn.com.duiba.tuia.media.model.req.ReqUpdateMediaApp;
import cn.com.duiba.tuia.media.model.rsp.RspIdAndValue;
import cn.com.duiba.tuia.media.model.rsp.RspMediaApp;
import cn.com.duiba.tuia.media.service.BaseService;
import cn.com.duiba.tuia.media.service.MediaAppConfigService;
import cn.com.duiba.tuia.media.service.MediaAppService;
import cn.com.duiba.tuia.media.service.impl.MediaCacheService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.Base58;
import cn.com.duiba.wolf.utils.SecurityUtils;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class MediaAppServiceImpl
extends BaseService
implements MediaAppService {
    protected Logger innerLog = LoggerFactory.getLogger((String)"innerLog");
    @Autowired
    private MediaAppDao mediaAppDao;
    @Autowired
    private RemoteAppService remoteAppService;
    @Autowired
    private MediaCacheService mediaCacheService;
    @Autowired
    private MediaAppCheckRecordDao mediaAppCheckRecordDao;
    @Autowired
    private MediaAppConfigDao mediaAppConfigDao;
    @Value(value="${media.consumer.encrypt.key}")
    private String consumerEncryptKey;
    @Autowired
    private MediaAppConfigService mediaAppConfigService;
    @Autowired
    private RemoteAppBackendService remoteAppBackendService;
    @Autowired
    private AccountDAO accountDAO;
    @Autowired
    private RemoteAppDirectService remoteAppDirectService;

    @Override
    public Boolean createMediaApp(ReqCreatMediaAppDto param) throws TuiaMediaException {
        CreateAppQueryParams createApp = new CreateAppQueryParams();
        Long mediaId = param.getMediaId();
        if (StringUtils.isEmpty((String)param.getAppName())) {
            throw new TuiaMediaException(ErrorCode.E0102001);
        }
        MediaAppDto mediaApp = this.mediaAppDao.getMediaAppByName(param.getAppName());
        if (null != mediaApp) {
            throw new TuiaMediaException(ErrorCode.E0401008);
        }
        createApp.setDeveloperId(mediaId);
        createApp.setName(param.getAppName());
        createApp.setMallCredits(Boolean.valueOf(true));
        createApp.setCreateSource(CreateAppQueryParams.CREATE_SOURCE_AD);
        MediaAppDto mediaAppDto = this.getMediaAppByRemote(createApp);
        mediaAppDto.setMediaId(mediaId);
        mediaAppDto.setAppName(param.getAppName());
        mediaAppDto.setPlatform(param.getPlatform());
        mediaAppDto.setIndustry(param.getIndustry());
        mediaAppDto.setCheckStatus(Integer.valueOf(0));
        mediaAppDto.setAppPackage(param.getAppPackage());
        mediaAppDto.setDescription(param.getDescription());
        mediaAppDto.setDownloadUrl(param.getDownloadUrl());
        mediaAppDto.setAppKeyWords(param.getAppKeyWords());
        this.mediaAppDao.insert(mediaAppDto);
        this.mediaCacheService.updateMediaAppCache(mediaAppDto.getAppId());
        ReqCreateMediaAppConfigDto dto = new ReqCreateMediaAppConfigDto();
        dto.setAppId(mediaAppDto.getAppId());
        dto.setChargeType(MediaAppConfigDto.CHARGE_TYPE_DIVIDED_INTO);
        dto.setPrice(Long.valueOf(0L));
        dto.setMediaSplitRatio(MediaAppConfigDto.MEDIA_SPLIT_RATIO_NUM);
        dto.setPlatformSplitRatio(MediaAppConfigDto.PLATFORM_SPLIT_RATIO_NUM);
        dto.setIsDeducted(MediaAppConfigDto.IS_DEDUCTED);
        dto.setDeductedPercent(MediaAppConfigDto.DEDUCTEDPERCENT_NUM);
        this.mediaAppConfigService.createMediaAppConfig(dto);
        this.mediaCacheService.updateAppIdAndName(mediaAppDto.getAppId(), mediaAppDto.getAppName());
        AccountDto accountDto = this.accountDAO.selectById(mediaId);
        AppDto appDto = new AppDto();
        appDto.setAppId(mediaAppDto.getAppId());
        appDto.setAppName(mediaAppDto.getAppName());
        appDto.setDeveloperAccount(accountDto.getEmail());
        appDto.setDeveloperId(mediaId);
        DubboResult dubboResult = this.remoteAppBackendService.insertMediaApp(appDto);
        this.doTuiaMediaException(dubboResult, "remoteAppBackendService.insertMediaApp");
        return true;
    }

    @Override
    public PageResultDto<RspMediaApp> getMediaAppList(ReqPageQueryMediaApp mediaAppQuery) throws TuiaMediaException {
        mediaAppQuery.setPageSize(50);
        mediaAppQuery.setRowStart((mediaAppQuery.getCurrentPage() - 1) * mediaAppQuery.getPageSize());
        mediaAppQuery.setSort("gmt_create");
        mediaAppQuery.setOrder("desc");
        ArrayList<RspMediaApp> rspMediaAppList = null;
        int totalNum = this.mediaAppDao.selectAmountByPageQuery(mediaAppQuery);
        if (totalNum > 0 && totalNum >= mediaAppQuery.getRowStart()) {
            List<MediaAppDto> mediaAppList = this.mediaAppDao.selectMediaAppList(mediaAppQuery);
            if (CollectionUtils.isNotEmpty(mediaAppList)) {
                rspMediaAppList = new ArrayList<RspMediaApp>(mediaAppList.size());
                for (MediaAppDto dto : mediaAppList) {
                    RspMediaApp rspMediaApp = new RspMediaApp();
                    rspMediaApp.setAppId(dto.getAppId());
                    rspMediaApp.setAppKey(dto.getAppKey());
                    String appSecret = dto.getAppSecret();
                    rspMediaApp.setAppSecret(BlowfishUtils.decryptBlowfish((String)(StringUtils.isNotEmpty((String)dto.getAppSecret()) ? appSecret : ""), (String)this.consumerEncryptKey));
                    rspMediaApp.setAppSecret(dto.getAppSecret());
                    rspMediaApp.setMediaId(dto.getMediaId());
                    rspMediaApp.setAppName(dto.getAppName());
                    rspMediaApp.setIndustry(dto.getIndustry());
                    rspMediaApp.setCheckStatus(dto.getCheckStatus());
                    rspMediaApp.setPlatform(dto.getPlatform());
                    rspMediaApp.setCreateDate(new DateTime((Object)dto.getGmtCreate()).toString("yyyy-MM-dd"));
                    rspMediaAppList.add(rspMediaApp);
                }
            } else {
                rspMediaAppList = ListUtils.EMPTY_LIST;
            }
        }
        return new PageResultDto(totalNum, rspMediaAppList, mediaAppQuery.getPageSize().intValue());
    }

    @Override
    public Boolean updateMediaApp(ReqUpdateMediaApp param) throws TuiaMediaException {
        Long cookieMediaId = param.getMediaId();
        Long reqAppId = param.getAppId();
        String reqAppName = param.getAppName();
        MediaAppDto mediaAppDto = this.mediaAppDao.selectMediaAppById(reqAppId);
        if (mediaAppDto == null) {
            this.logger.error("the mediaAppDto is not exist, the appId = [{}]", (Object)reqAppId);
            throw new TuiaMediaException(ErrorCode.E0401001);
        }
        if ((long)mediaAppDto.getMediaId().intValue() != cookieMediaId) {
            this.logger.error("the mediaApp is not owned, the appId = [{}] the mediaId=[{}]", (Object)reqAppId, (Object)cookieMediaId);
            throw new TuiaMediaException(ErrorCode.E0401009);
        }
        if (mediaAppDto.getCheckStatus() != null && (mediaAppDto.getCheckStatus() == 2 || mediaAppDto.getCheckStatus() == 1)) {
            param.setCheckStatus(0);
            this.mediaAppDao.update(param);
            this.mediaCacheService.updateMediaAppCache(reqAppId);
        }
        if (!mediaAppDto.getAppName().equals(reqAppName)) {
            this.mediaCacheService.updateAppIdAndName(reqAppId, reqAppName);
            AccountDto accountDto = this.accountDAO.selectById(cookieMediaId);
            AppDto appDto = new AppDto();
            appDto.setAppId(mediaAppDto.getAppId());
            appDto.setAppName(reqAppName);
            appDto.setDeveloperAccount(accountDto.getEmail());
            appDto.setDeveloperId(cookieMediaId);
            DubboResult dubboResult = this.remoteAppBackendService.updateMediaApp(appDto);
            this.doTuiaMediaException(dubboResult, "remoteAppBackendService.updateMediaApp");
        }
        return true;
    }

    @Override
    public MediaAppDto getMediaAppDto(Long appId) throws TuiaMediaException {
        MediaAppDto mediaAppDto = this.mediaAppDao.selectMediaAppById(appId);
        if (mediaAppDto == null) {
            this.logger.error("the mediaAppDto is not exist, the appId = [{}]", (Object)appId);
            throw new TuiaMediaException(ErrorCode.E0401001);
        }
        return mediaAppDto;
    }

    private void syncActivityCenterWhiteList(Long appId) throws TuiaMediaException {
        try {
            AppDirectDto appDirect = new AppDirectDto();
            appDirect.setAppId(appId);
            this.remoteAppDirectService.insert(appDirect);
        }
        catch (Exception e) {
            this.logger.error("syncActivityCenterWhiteList error, the appId = " + appId, (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0000001);
        }
    }

    @Override
    public Boolean updateMediaAppStatus(ReqUpdateMediaAppStatusDto param) throws TuiaMediaException {
        int result = this.mediaAppDao.updateMediaAppStatus(param);
        MediaAppDto mediaAppDto = null;
        if (result == 1 && (param.getCheckStatus() == 2 || param.getCheckStatus() == 1)) {
            mediaAppDto = this.mediaAppDao.selectMediaAppById(param.getAppId());
            MediaAppCheckRecordDto checkRecordDto = new MediaAppCheckRecordDto();
            checkRecordDto.setAppId(mediaAppDto.getAppId());
            checkRecordDto.setCheckType(mediaAppDto.getCheckStatus());
            checkRecordDto.setMediaId(mediaAppDto.getMediaId());
            this.mediaAppCheckRecordDao.insert(checkRecordDto);
        }
        if (result == 1 && param.getCheckStatus() == 1) {
            this.syncActivityCenterWhiteList(param.getAppId());
            RspBaseInnerLogDto innerLogDto = this.buildAppInnerLog(mediaAppDto);
            this.innerLog.info(innerLogDto.toString());
        }
        this.mediaCacheService.updateMediaAppCache(param.getAppId());
        return true;
    }

    private MediaAppDto getMediaAppByRemote(CreateAppQueryParams param) throws TuiaMediaException {
        MediaAppDto mediaApp = new MediaAppDto();
        DubboResult appResult = this.remoteAppService.createApp(param);
        if (appResult == null || appResult.getResult() == null) {
            this.logger.error("the remoteAppService.createApp is error, the param = [{}]", (Object)param);
            throw new TuiaMediaException(ErrorCode.E0401003);
        }
        DubboResult dubboResult = this.remoteAppService.getSimpleApp((Long)appResult.getResult());
        if (dubboResult == null || dubboResult.getResult() == null) {
            throw new TuiaMediaException(ErrorCode.E0000001);
        }
        AppSimpleDto app = (AppSimpleDto)dubboResult.getResult();
        if (app.getAppKey() == null || app.getId() == null) {
            throw new TuiaMediaException(ErrorCode.E0401003);
        }
        mediaApp.setAppKey(app.getAppKey());
        mediaApp.setAppId(app.getId());
        mediaApp.setAppSecret(app.getAppSecret());
        String appSecret = this.generate();
        mediaApp.setAppSecret(BlowfishUtils.encryptBlowfish((String)(StringUtils.isNotEmpty((String)appSecret) ? appSecret : ""), (String)this.consumerEncryptKey));
        return mediaApp;
    }

    @Override
    public List<Long> selectIdsByName(String appName) throws TuiaMediaException {
        return this.mediaAppDao.selectIdsByName(appName);
    }

    @Override
    public List<IdAndName> selectAppIdAndName(List<Long> appIds) throws TuiaMediaException {
        int size = appIds == null ? 0 : appIds.size();
        ArrayList<IdAndName> result = new ArrayList<IdAndName>(size);
        if (appIds != null) {
            int j = 0;
            for (int i = 1; i <= size; ++i) {
                if (i % 100 != 0 && i != size) continue;
                result.addAll(this.mediaAppDao.selectAppIdAndName(appIds.subList(j, i)));
                j = i;
            }
        }
        return result;
    }

    @Override
    public List<RspIdAndValue> selectAppIdAndNameByMediaId(Long mediaId) throws TuiaMediaException {
        List<IdAndName> dtoList = this.mediaAppDao.selectAppIdAndNameByMediaId(mediaId);
        if (CollectionUtils.isNotEmpty(dtoList)) {
            ArrayList<RspIdAndValue> rspList = new ArrayList<RspIdAndValue>(dtoList.size());
            for (IdAndName dto : dtoList) {
                RspIdAndValue rspDto = new RspIdAndValue();
                if (null != dto.getId()) {
                    rspDto.setId(Long.toString(dto.getId()));
                }
                rspDto.setValue(dto.getName());
                rspList.add(rspDto);
            }
            return rspList;
        }
        return ListUtils.EMPTY_LIST;
    }

    private String generate() {
        byte[] bs = SecurityUtils.encode2BytesBySHA((String)UUID.randomUUID().toString());
        return Base58.encode((byte[])bs);
    }

    @Override
    public boolean selectAllAppIdAndName() throws TuiaMediaException {
        return this.mediaCacheService.getAppIdAndNameCache();
    }

    @Override
    public boolean delAllAppIdAndName() throws TuiaMediaException {
        return this.mediaCacheService.delAppIdAndNameCache();
    }

    @Override
    public String selectAppNameById(Long appId) throws TuiaMediaException {
        MediaAppDto dto = this.mediaAppDao.selectMediaAppById(appId);
        if (dto == null) {
            return null;
        }
        String appName = dto.getAppName();
        return StringUtils.isBlank((String)appName) ? null : appName;
    }

    private RspBaseInnerLogDto buildAppInnerLog(MediaAppDto appDto) throws TuiaMediaException {
        RspAppInnerLogDto dto = new RspAppInnerLogDto();
        dto.setAppId(appDto.getAppId());
        dto.setAppName(appDto.getAppName());
        dto.setCheckStatus(appDto.getCheckStatus());
        dto.setMediaId(appDto.getMediaId());
        dto.setPlatform(appDto.getPlatform());
        MediaAppConfigDto mediaAppConfigDto = this.mediaAppConfigDao.selectMediaAppConfigById(appDto.getAppId());
        if (mediaAppConfigDto != null) {
            dto.setChargeType(mediaAppConfigDto.getChargeType());
            dto.setMediaSplitRatio(Double.valueOf((double)mediaAppConfigDto.getMediaSplitRatio().intValue() / 100.0));
            dto.setPlatformSplitRatio(Double.valueOf((double)mediaAppConfigDto.getPlatformSplitRatio().intValue() / 100.0));
            dto.setPrice(mediaAppConfigDto.getPrice());
            dto.setTime(new DateTime((Object)mediaAppConfigDto.getGmtCreate()).toString("yyyy-MM-dd HH:mm:ss"));
        }
        return new RspBaseInnerLogDto(RspBaseInnerLogDto.GROUP_TYPE_LOG, RspBaseInnerLogDto.MEDIA_TYPE_LOG, new DateTime((Object)new Date()).toString("yyyy-MM-dd HH:mm:ss"), null, null, JSONObject.toJSONString((Object)dto));
    }
}

