/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.service.impl;

import cn.com.duiba.tuia.media.api.dto.AccountDto;
import cn.com.duiba.tuia.media.api.dto.MediaAppDataDto;
import cn.com.duiba.tuia.media.api.dto.MediaAppDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqActivityDto;
import cn.com.duiba.tuia.media.api.utils.CacheKeyUtils;
import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.AccountDAO;
import cn.com.duiba.tuia.media.dao.ActivityDAO;
import cn.com.duiba.tuia.media.dao.MediaAppDao;
import cn.com.duiba.tuia.media.domain.ActivityDto;
import cn.com.duiba.tuia.media.model.IdAndName;
import cn.com.duiba.tuia.media.service.MediaAppService;
import cn.com.duiba.tuia.media.service.impl.BaseCacheService;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MediaCacheService
extends BaseCacheService {
    @Autowired
    MediaAppDao mediaAppDao;
    @Autowired
    private AccountDAO accountDAO;
    @Autowired
    private ActivityDAO activityDAO;
    @Autowired
    private MediaAppService mediaAppService;

    public void updateMediaCache(final long mediaId, final boolean isValid) {
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                MediaCacheService.this.redisClient.setex(CacheKeyUtils.getMediaStatusKey((long)mediaId), 604800, JSONObject.toJSONString((Object)isValid));
            }
        });
    }

    public void updateMediaAppCache(final long mediaAppId) {
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    MediaCacheService.this.doGetMediaApp(mediaAppId);
                }
                catch (Exception e) {
                    MediaCacheService.this.logger.error("updateMediaAppCache error", (Throwable)e);
                }
            }
        });
    }

    public MediaAppDataDto getMediaApp(long mediaAppId) throws TuiaMediaException {
        String strMedaiAppData = this.redisClient.get(CacheKeyUtils.getMediaAppKey((long)mediaAppId));
        MediaAppDataDto cacheData = StringUtils.isEmpty((String)strMedaiAppData) ? this.doGetMediaApp(mediaAppId) : (MediaAppDataDto)JSONObject.parseObject((String)strMedaiAppData, MediaAppDataDto.class);
        return cacheData;
    }

    public MediaAppDataDto getMediaAppByKey(String appKey) throws TuiaMediaException {
        String strMedaiAppData = this.redisClient.get(CacheKeyUtils.getMediaAppByKey((String)appKey));
        MediaAppDataDto cacheData = StringUtils.isEmpty((String)strMedaiAppData) ? this.updateMediaAppByKey(appKey) : (MediaAppDataDto)JSONObject.parseObject((String)strMedaiAppData, MediaAppDataDto.class);
        return cacheData;
    }

    private MediaAppDataDto doGetMediaApp(long mediaAppId) throws TuiaMediaException {
        MediaAppDataDto cacheData = null;
        MediaAppDto mediaAppDto = this.mediaAppDao.selectMediaAppById(mediaAppId);
        if (mediaAppDto != null) {
            cacheData = this.buildMediaAppDataDto(mediaAppDto);
            this.redisClient.setex(CacheKeyUtils.getMediaAppKey((long)mediaAppId), 604800, JSONObject.toJSONString((Object)cacheData));
            this.redisClient.setex(CacheKeyUtils.getMediaAppByKey((String)mediaAppDto.getAppKey()), 604800, JSONObject.toJSONString((Object)cacheData));
        }
        return cacheData;
    }

    public MediaAppDataDto updateMediaAppByKey(String appkey) throws TuiaMediaException {
        MediaAppDataDto cacheData = null;
        MediaAppDto mediaAppDto = this.mediaAppDao.selectByAppKey(appkey);
        if (mediaAppDto != null) {
            cacheData = this.buildMediaAppDataDto(mediaAppDto);
            this.redisClient.setex(CacheKeyUtils.getMediaAppByKey((String)appkey), 604800, JSONObject.toJSONString((Object)cacheData));
        }
        return cacheData;
    }

    private MediaAppDataDto buildMediaAppDataDto(MediaAppDto mediaAppDto) {
        MediaAppDataDto cacheData = new MediaAppDataDto(mediaAppDto.getMediaId().longValue(), mediaAppDto.getAppKey(), mediaAppDto.getAppSecret(), mediaAppDto.getIndustry());
        cacheData.setValid(1 == mediaAppDto.getCheckStatus());
        cacheData.setAppId(mediaAppDto.getAppId().longValue());
        cacheData.setPlatform(mediaAppDto.getPlatform());
        return cacheData;
    }

    public Boolean isValidMediaApp(long mediaAppId) throws TuiaMediaException {
        MediaAppDataDto cacheData = this.getMediaApp(mediaAppId);
        if (cacheData != null && cacheData.isValid() && this.doGetMediaValid(cacheData.getMediaId()).booleanValue()) {
            return true;
        }
        return false;
    }

    private Boolean doGetMediaValid(long mediaId) throws TuiaMediaException {
        String mediaValid = this.redisClient.get(CacheKeyUtils.getMediaStatusKey((long)mediaId));
        boolean isValid = false;
        if (mediaValid == null) {
            AccountDto accountDto = this.accountDAO.selectById(mediaId);
            if (accountDto == null) {
                throw new TuiaMediaException(ErrorCode.E0102001);
            }
            if (1 == accountDto.getEmailStatus() && 0 == accountDto.getFreezeStatus()) {
                isValid = true;
            }
            this.redisClient.setex(CacheKeyUtils.getMediaStatusKey((long)mediaId), 604800, JSONObject.toJSONString((Object)isValid));
        }
        return isValid;
    }

    public boolean getAppIdAndNameCache() throws TuiaMediaException {
        List<IdAndName> idAndNames = this.mediaAppDao.selectAllAppIdAndName();
        for (IdAndName dto : idAndNames) {
            this.redisClient.setex(CacheKeyUtils.getAppIdAndNameKey((long)dto.getId()), 604800, dto.getName());
        }
        return true;
    }

    public boolean delAppIdAndNameCache() throws TuiaMediaException {
        List<IdAndName> idAndNames = this.mediaAppDao.selectAllAppIdAndName();
        for (IdAndName dto : idAndNames) {
            this.redisClient.del(CacheKeyUtils.getAppIdAndNameKey((long)dto.getId()));
        }
        return true;
    }

    public void updateAppIdAndName(Long appId, String appName) {
        this.redisClient.set(CacheKeyUtils.getAppIdAndNameKey((long)appId), appName);
    }

    public String getAppNameByIdKey(Long appId) throws TuiaMediaException {
        String appName = null;
        if (appId != null && StringUtils.isBlank((String)(appName = this.redisClient.get(CacheKeyUtils.getAppIdAndNameKey((long)appId)))) && StringUtils.isNotBlank((String)(appName = this.mediaAppService.selectAppNameById(appId)))) {
            this.redisClient.setex(CacheKeyUtils.getAppIdAndNameKey((long)appId), 604800, appName);
            return appName;
        }
        return appName;
    }

    public AccountDto getAccountCacheById(Long mediaId) throws TuiaMediaException {
        AccountDto accountDto;
        String accountStr = this.redisClient.get(CacheKeyUtils.getMediaAccountByKey((Long)mediaId));
        if (StringUtils.isEmpty((String)accountStr)) {
            accountDto = this.accountDAO.selectById(mediaId);
            if (accountDto != null) {
                this.redisClient.setex(CacheKeyUtils.getMediaAccountByKey((Long)mediaId), 604800, JSONObject.toJSONString((Object)accountDto));
            }
        } else {
            accountDto = (AccountDto)JSONObject.parseObject((String)accountStr, AccountDto.class);
        }
        return accountDto;
    }

    public boolean delAllAppCache() throws TuiaMediaException {
        List<MediaAppDto> appList = this.mediaAppDao.selectAllAppCache();
        for (MediaAppDto dto : appList) {
            this.redisClient.del(CacheKeyUtils.getMediaAppKey((long)dto.getAppId()));
        }
        return true;
    }

    public boolean initAllAppCache() throws TuiaMediaException {
        List<MediaAppDto> appList = this.mediaAppDao.selectAllAppCache();
        for (MediaAppDto dto : appList) {
            MediaAppDataDto cacheData = this.buildMediaAppDataDto(dto);
            this.redisClient.setex(CacheKeyUtils.getMediaAppKey((long)dto.getAppId()), 604800, JSONObject.toJSONString((Object)cacheData));
        }
        return true;
    }

    public boolean delAllAccountCache() throws TuiaMediaException {
        List<AccountDto> accountList = this.accountDAO.selectAllListCache();
        for (AccountDto dto : accountList) {
            this.redisClient.del(CacheKeyUtils.getMediaAccountByKey((Long)dto.getMediaId()));
        }
        return true;
    }

    public boolean initAllAccountCache() throws TuiaMediaException {
        List<AccountDto> accountList = this.accountDAO.selectAllListCache();
        for (AccountDto dto : accountList) {
            this.redisClient.setex(CacheKeyUtils.getMediaAccountByKey((Long)dto.getMediaId()), 3600, JSONObject.toJSONString((Object)dto));
        }
        return true;
    }

    public boolean refreshAllRedisActivity() throws TuiaMediaException {
        List<ActivityDto> list = this.activityDAO.getList(new ReqActivityDto());
        for (ActivityDto activityDto : list) {
            this.redisClient.del(CacheKeyUtils.getActivityByKey((String)(activityDto.getActivityId() + "-" + activityDto.getActivityType())));
        }
        return true;
    }
}

