/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.utils;

import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtils {
    private static Logger logger = LoggerFactory.getLogger(JsonUtils.class);
    private static ObjectMapper mapper = null;
    private JsonUtils ju;

    public JsonUtils getJsonUtils() {
        if (this.ju == null) {
            this.ju = new JsonUtils();
        }
        return this.ju;
    }

    static ObjectMapper getObjectMapper() {
        if (mapper == null) {
            mapper = new ObjectMapper();
        }
        return mapper;
    }

    public static void objToJSON(HttpServletResponse response, Object obj) {
        try {
            JsonUtils.setResponse(response);
            String jsonStr = JsonUtils.getObjectMapper().writeValueAsString(obj);
            PrintWriter out = response.getWriter();
            out.print(jsonStr);
            out.close();
        }
        catch (IOException e) {
            logger.error("JsonUtils.objToJSON happen IOException", (Throwable)e);
        }
    }

    public static String objectToString(Object obj) throws TuiaMediaException {
        try {
            return JsonUtils.getObjectMapper().writeValueAsString(obj);
        }
        catch (Exception e) {
            logger.error("JsonUtils.objectToString is error! the obj = [{}], the e = [{}]", obj, (Object)e);
            throw new TuiaMediaException(ErrorCode.E0001005.getErrorCode(), "\u5bf9\u8c61\u8f6cjson\u5f02\u5e38");
        }
    }

    public static <T> T jsonToObject(Class<T> clazz, String json) throws TuiaMediaException {
        try {
            return (T)JsonUtils.getObjectMapper().readValue(json, clazz);
        }
        catch (Exception e) {
            logger.error("JsonUtils.jsonToObject is error! the clazz=[{}],the json=[{}], the e = [{}]", new Object[]{clazz, json, e});
            throw new TuiaMediaException(ErrorCode.E0001005.getErrorCode(), "json\u8f6c\u5bf9\u8c61\u5f02\u5e38");
        }
    }

    public static void setResponse(HttpServletResponse response) {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("text/html");
    }
}

