package cn.com.duiba.tuia.media.common.tool;

import java.util.Arrays;
import java.util.List;

/**
 * 
 * ClassName: ValidateTool <br/>
 * date: 2016年12月8日 下午7:01:02 <br/>
 *
 * @author ZFZ
 * @version 
 * @since JDK 1.6
 */
public class ValidateTool {

    private static final List<Character> letters   = Arrays.asList('a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j',
                                                                   'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't',
                                                                   'u', 'v', 'w', 'x', 'y', 'z');
    private static final List<Character> numChar   = Arrays.asList('0', '1', '2', '3', '4', '5', '6', '7', '8', '9');
    private static final List<Character> otherChar = Arrays.asList('-', '_', '.');

    private ValidateTool                 vt;

    public ValidateTool getValidateTool() {
        if (vt == null) {
            vt = new ValidateTool();
        }
        return vt;
    }

    /**
     * 
     * validateEmail:(邮箱验证). <br/>
     *
     * @author ZFZ
     * @param email
     * @return
     * @since JDK 1.6
     */
    public static boolean validateEmail(String email) {
        boolean result = true;

        if (email != null && email.trim().length() != 0) {
            String vEmail = email.toLowerCase();
            String[] parts = vEmail.split("@");

            // 必须包含@符号，并且只有一个
            if (parts.length != 2) {
                return false;
            }

            // @符号前的文本，只能包含 a-z,A-Z，0-9，下划线(_),中杠(-),点号(.)，第一个和最后一个字符必须是字母或数字，不能连续出现
            char[] part1 = parts[0].toCharArray();
            if (part1.length != 0) {
                if (!letters.contains(part1[0]) && !numChar.contains(part1[0])) {
                    return false;
                }

                int count = 0;
                for (char c : part1) {
                    if (!letters.contains(c) && !numChar.contains(c) && !otherChar.contains(c)) {
                        return false;
                    } else {
                        if (otherChar.contains(c)) {
                            count++;
                            if (count >= 2) {
                                return false;
                            }
                        } else {
                            count = 0;
                        }
                    }
                }

                if (!letters.contains(part1[part1.length - 1]) && !numChar.contains(part1[part1.length - 1])) {
                    return false;
                }
            } else {
                return false;
            }

            // @符号后的文本，必须包含至少一个点号(.),只能包含 a-z,A-Z，点号(.) ，邮箱结尾长度大于等于2，只能包含 a-z,A-Z
            char[] part2 = parts[1].toCharArray();
            if (part2.length != 0) {
                if (!letters.contains(part2[0]) && !numChar.contains(part2[0])) {
                    return false;
                }
                if (parts[1].indexOf("..") != -1) {
                    return false;
                }

                int count = 0;
                for (char c : part2) {
                    if (!letters.contains(part2[0]) && !numChar.contains(part2[0]) && c != '.') {
                        return false;
                    } else {
                        if (c == '.') {
                            count++;
                        }
                    }
                }
                if (count > 0) {
                    if (!letters.contains(part2[part2.length - 1]) && !numChar.contains(part2[part2.length - 1])) {
                        return false;
                    }
                } else {
                    return false;
                }

                String[] endStr = parts[1].split("\\.");
                if (endStr[endStr.length - 1].length() >= 2) {
                    char[] endChar = endStr[endStr.length - 1].toCharArray();
                    for (char c : endChar) {
                        if (!letters.contains(c)) {
                            return false;
                        }
                    }
                }

            } else {
                return false;
            }

        }

        return result;
    }

    /**
     * 
     * validatePhone:(验证手机). <br/>
     *
     * @author ZFZ
     * @param phone
     * @return
     * @since JDK 1.6
     */
    public static boolean validatePhone(String phone) {
        boolean result = true;

        // 必须11位数字
        if (phone == null || phone.length() != 11) {
            return false;
        }
        char[] phones = phone.toCharArray();

        // 必须以1开头
        if (phones[0] != '1') {
            return false;
        } else {
            for (char c : phones) {
                if (!numChar.contains(c)) {
                    return false;
                }
            }
        }

        return result;
    }

}
