/**
 * 文件名： ErrorCode.java 此类描述的是： 作者: leiliang 创建时间: 2016年3月23日 上午10:15:33
 */
package cn.com.duiba.tuia.media.common.constants;

/**
 * 此类描述的是： 推啊core工程内部自定义错误码规范<br>
 * 错误码组成：AABCCC
 * <ul>
 * AA：模块编号
 * <li>00：公用模块</li>
 * <li>01：用户模块</li>
 * <li>02：媒体模块</li>
 * <li>03：广告位模块</li>
 * <li>04：数据模块</li>
 * </ul>
 * <ul>
 * BB：错误类型
 * <li>01 - 媒体级错误（参数错误）</li>
 * <li>02 - 业务级错误（service自身错误）</li>
 * <li>03 - 依赖级错误（service调用第三方服务错误）</li>
 * <li>04 - 交互级业务提醒（正常业务逻辑，非错误，需告知用户，如库存不足）</li>
 * </ul>
 * <ul>
 * CCC:具体错误码 举例
 * <li>通用的成功状态码：000</li>
 * <li>通用的未知错误码：999</li>
 * </ul>
 * <ul>
 * 业务前缀
 * <li>tuia-core：TC_</li>
 * </ul>
 *
 * @规范： http://cf.dui88.com/pages/viewpage.action?pageId=3544570
 * @汇总文档：http://cf.dui88.com/pages/viewpage.action?pageId=3560274
 */
public enum ErrorCode {

    // 公共模块00
    /** 成功. */
    E0000000("0", "成功"),

    /** dubbo接口调用失败 */
    E0000001("0000001", "dubbo接口调用失败"),

    /** 请重新登录. */
    E9999998("9999998", "请重新登录"),

    E9999999("9999999", "未知错误"),

    /** 数据库错误. */
    E0002001("0002001", "数据库错误"),

    /** MD5解密失败. */
    E0002002("0002002", "MD5解密失败"),

    /** MD5加密失败. */
    E0002003("0002003", "MD5加密失败"),

    /** OSS上传文件失败. */
    E0003003("0003003", "OSS上传文件失败"),

    /** 文件不存在. */
    E0002004("0002004", "文件不存在"),

    /** 上传文件类型不符. */
    E0002005("0002005", "上传文件类型不符"),

    /** 参数错误. */
    E0001005("0001005", "参数错误"),

    /** IO异常 */
    E0002006("0002006", "IO异常"),

    /** 极验验证码校验失败. */
    E0001007("0001007", "极验验证码校验失败"),

    /** 发送短信验证码失败. */
    E0002008("0002008", "发送短信验证码失败"),

    /** 非法的短信验证码类型. */
    E0001009("0001009", "非法的短信验证码类型"),

    /** 短信验证码校验失败. */
    E0001010("0001010", "短信验证码校验失败"),

    /** 重复发送验证码. */
    E0001011("0001011", "重复发送验证码"),

    // 用户模块
    /** 用户不存在. */
    E0102001("0102001", "用户不存在"),

    /** 密码不正确. */
    E0102002("0102002", "密码不正确"),

    /** 验证码错误. */
    E0102003("0102003", "验证码错误"),

    /** 您的账号被冻结. */
    E0102004("0102004", "您的账号被冻结"),

    /** 您的账号处于非法的冻结状态. */
    E0102005("0102005", "您的账号处于非法的冻结状态"),

    /** 您的账号在审核中. */
    E0102006("0102006", "您的账号在审核中"),

    /** 您的账号审核未通过. */
    E0102007("0102007", "您的账号审核未通过"),

    /** 您的账号处于非法的审核状态. */
    E0102008("0102008", "您的账号处于非法的审核状态"),

    /** 验证链接过期失效. */
    E0102009("0102009", "验证链接过期失效"),

    /** 邮箱格式错误. */
    E0102010("0102010", "邮箱格式错误"),

    /** 该邮箱账号已注册. */
    E0102011("0102011", "该邮箱账号已注册"),

    /** 该邮箱账号已验证. */
    E0102012("0102012", "该邮箱账号已验证"),

    /** 新密码不能和旧密码一致. */
    E0102013("0102013", "新密码不能和旧密码一致"),

    /** 非审核拒绝的账号不可修改审核信息. */
    E0102015("0102015", " 非审核拒绝的账号不可修改审核信息"),

    /** 邮箱被占用. */
    E0102016("0102016", "邮箱被占用"),

    /** 邮箱没有修改. */
    E0104017("0104017", "邮箱没有修改"),

    /** 更换邮箱失败. */
    E0102018("0102018", "更换邮箱失败"),

    /** 邮箱未激活. */
    E0102019("0102019", "邮箱未激活"),

    /** 注册失败. */
    E0102020("0102020", "注册失败"),

    /** 手机号已经注册. */
    E0102021("0102021", "手机号已经注册"),

    /** 邮箱处于非法审核状态. */
    E0102022("0102022", "邮箱处于非法审核状态"),
    // 媒体模块

    // 广告位模块

    /** 屏蔽策略是其他用户的，您无权操作. */
    E0304001("0304001", "屏蔽策略是其他用户的，您无权操作"),

    /** 屏蔽策略不存在. */
    E0304002("0304002", "屏蔽策略不存在"),

    /** 屏蔽策略的名称已存在. */
    E0304003("0304003", "屏蔽策略的名称已存在"),

    /** 该广告位您无权操作 */
    E0304004("0304004", "该广告位您无权操作"),

    /** 该广告位媒体状态或账户状态异常 */
    E0304005("0304005", "该广告位媒体状态或账户状态异常"),

    /** 广告位需要先审核通过 */
    E0304006("0304006", "广告位需要先审核通过"),

    /** 已经审核过. */
    E0304007("0304007", "已经审核过"),

    /** 该广告位不存在. */
    E0304008("0304008", "该广告位不存在"),
    
    /**广告位开启状态,该广告位不能删除. */
    E0304009("0304009", "广告位开启状态,该广告位不能删除"),

    // 媒体模块

    /** 媒体信息不存在 */
    E0401001("0401001", "媒体信息不存在"),

    /** 媒体appId不存在 */
    E0401002("0401002", "媒体appId不存在"),

    /** 创建媒体信息时参数错误 */
    E0401003("0401003", "创建媒体信息时参数错误"),

    /** 查询媒体app不存在 */
    E0401004("0401004", "查询媒体app不存在"),

    /** 查询媒体app配置不存在 */
    E0401005("0401005", "查询媒体app配置不存在"),

    /** 媒体appId为null */
    E0401006("0401006", "查询媒体appId为null"),

    /** 媒体状态位异常 */
    E0401007("0401007", "媒体状态位异常"),

    /** 媒体app已存在 */
    E0401008("0401008", "媒体app已存在"),
    
    /** 操作的媒体不属于当前登陆用户 */
    E0401009("0401009", "操作的媒体不属于当前登陆用户"),

    // 活动模块

    E0501001("0501001", "媒体活动不存在"),

    E0501002("0501002", "输入的排序位置错误"),

    E0501003("0501003","规格不存在"),

    E0501004("0501004","活动计划不存在");



    /** 错误码. */
    private String errorCode;

    /** 中文描述. */
    private String desc;

    /**
     * The Constructor.
     *
     * @param errorCode the error code
     * @param desc the desc
     */
    private ErrorCode(String errorCode, String desc) {
        this.errorCode = errorCode;
        this.desc = desc;
    }

    /**
     * Gets the error code.
     *
     * @return the error code
     */
    public String getErrorCode() {
        return errorCode;
    }

    /**
     * Gets the desc.
     *
     * @return the desc
     */
    public String getDesc() {
        return desc;
    }

}
