/**
 * Project Name:media-common<br>
 * File Name:SlotPictureSizeEnmu.java<br>
 * Package Name:cn.com.duiba.tuia.media.common.constants<br>
 * Date:2016年10月19日下午7:52:36<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.media.common.constants;

/**
 * ClassName: SlotPictureSizeEnmu <br/>
 * Function: 广告位尺寸大小枚举. <br/>
 * date: 2016年10月19日 下午7:52:36 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
public enum InformationStreamPictureSizeEnmu {

    TYPE_0(0L, SlotPictureSizeEnmu.SIZE_0.getSizeId()), TYPE_1(1L, SlotPictureSizeEnmu.SIZE_1.getSizeId()),

    ;

    /** 尺寸类型. */
    private Long type;

    /** 尺寸ID. */
    private int  sizeId;

    /**
     * 
     * Creates a new instance of InformationStreamPictureSizeEnmu.
     *
     * @param type
     * @param sizeId
     */
    private InformationStreamPictureSizeEnmu(Long type, int sizeId) {
        this.type = type;
        this.sizeId = sizeId;
    }

    /**
     * 
     * getSizeIdByType:(这里用一句话描述这个方法的作用). <br/>
     *
     * @author ZFZ
     * @param type
     * @return
     * @since JDK 1.6
     */
    public static Integer getSizeIdByType(Long type) {
        InformationStreamPictureSizeEnmu[] values = InformationStreamPictureSizeEnmu.values();
        for (InformationStreamPictureSizeEnmu value : values) {
            if (type == value.getType()) {
                return value.getSizeId();
            }
        }
        return null;
    }

    /**
     * 
     * getFlowTypeBySizeId:(根据sizeId查询具体尺寸标号). <br/>
     *
     * @author ZFZ
     * @param sizeId
     * @return
     * @since JDK 1.6
     */
    public static Integer getFlowTypeBySizeId(int sizeId) {
        InformationStreamPictureSizeEnmu[] values = InformationStreamPictureSizeEnmu.values();
        Integer flowType = null;
        int i = 0;
        for (InformationStreamPictureSizeEnmu value : values) {
            if (sizeId == value.getSizeId()) {
                flowType = i;
            }
            i++;
        }
        return flowType;
    }

    /**
     * type.
     *
     * @return the type
     * @since JDK 1.6
     */

    private Long getType() {
        return type;
    }

    /**
     * type.
     *
     * @param type the type to set
     * @since JDK 1.6
     */
    @SuppressWarnings("unused")
    private void setType(Long type) {
        this.type = type;
    }

    /**
     * sizeId.
     *
     * @return the sizeId
     * @since JDK 1.6
     */
    private int getSizeId() {
        return sizeId;
    }

    /**
     * sizeId.
     *
     * @param sizeId the sizeId to set
     * @since JDK 1.6
     */
    @SuppressWarnings("unused")
    private void setSizeId(int sizeId) {
        this.sizeId = sizeId;
    }
}
