/**
 * Project Name:manager-common<br>
 * File Name:DataTool.java<br>
 * Package Name:cn.com.duiba.tuia.manager.tool<br>
 * Date:2016年6月28日上午11:25:24<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.media.common.tool;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

/**
 * ClassName: DataTool <br/>
 * Function: 数据工具类. <br/>
 * date: 2016年6月28日 上午11:25:24 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.7
 */
public class DataTool {

    private DataTool dt;

    public DataTool getDataTool() {
        if (dt == null) {
            dt = new DataTool();
        }
        return dt;
    }

    /**
     * 计算点击均价.
     *
     * @param divisor 分子
     * @param dividend 分母
     * @return the integer
     */
    public static Long calculateAveragePrice(Long divisor, Long dividend) {
        Long result = null;
        if (dividend != null && dividend.longValue() != 0 && divisor != null) {
            BigDecimal bigDivisor = new BigDecimal(divisor);
            BigDecimal bigDividend = new BigDecimal(dividend);
            return bigDivisor.divide(bigDividend, BigDecimal.ROUND_HALF_UP).longValue();
        }
        return result;
    }

    /**
     * 
     * calculateEcpm:(计算 每千次的有效均价.). <br/>
     *
     * @author ZFZ
     * @param divisor 分子
     * @param dividend 分母
     * @return
     * @since JDK 1.6
     */
    public static Long calculateEcpm(Long divisor, Long dividend) {
        Long result = null;
        if (dividend != null && dividend.longValue() != 0 && divisor != null) {
            BigDecimal bigDivisor = new BigDecimal(divisor * 1000);
            BigDecimal bigDividend = new BigDecimal(dividend);
            return bigDivisor.divide(bigDividend, BigDecimal.ROUND_HALF_UP).longValue();
        }
        return result;
    }

    /**
     * 计算点击率 点击量/曝光量 *100
     * 
     * @param divisor
     * @param dividend
     * @return
     */
    public static Long calculateClickRade(Long divisor, Long dividend) {
        Long result = null;
        if (dividend != null && dividend.longValue() != 0 && divisor != null) {
            BigDecimal bigDivisor = new BigDecimal(divisor);
            BigDecimal bigDividend = new BigDecimal(dividend);
            Double res = bigDivisor.divide(bigDividend, 2, BigDecimal.ROUND_HALF_UP).doubleValue() * 100;
            return res.longValue();
        }
        return result;
    }

    /**
     * 判断两个Integer类型数据是否相等.<br>
     * <ol>
     * <li>true：isSame(null, null)</li>
     * <li>false：isSame(null, 1)</li>
     * <li>false：isSame(1, null)</li>
     * <li>true：isSame(1, 1)</li>
     * </ol>
     *
     * @param integer1 the integer1
     * @param integer2 the integer2
     * @return true, if checks if is same
     */
    public static boolean isSame(Integer integer1, Integer integer2) {
        if (integer1 == null && integer2 == null) {
            return true;
        }

        if (integer1 != null && integer2 != null && (integer1.intValue() == integer2.intValue())) {
            return true;
        }
        return false;
    }

    /**
     * 判断两个Long类型数据是否相等.<br>
     * <ol>
     * <li>true：isSame(null, null)</li>
     * <li>false：isSame(null, 1)</li>
     * <li>false：isSame(1, null)</li>
     * <li>true：isSame(1, 1)</li>
     * </ol>
     *
     * @param long1 the long1
     * @param long2 the long2
     * @return true, if checks if is same
     */
    public static boolean isSame(Long long1, Long long2) {
        if (long1 == null && long2 == null) {
            return true;
        }

        if (long1 != null && long2 != null && (long1 - long2 == 0)) {
            return true;
        }
        return false;
    }

    /**
     * 把一个2,44,51,34,123,123,4（都是数字）形式的字符串解析成一个List<Long>.
     *
     * @param arrayStr the array str
     * @return the long list by str
     */
    public static List<Long> getLongListByStr(String arrayStr) {
        if (StringUtils.isBlank(arrayStr)) {
            return Collections.emptyList();
        }
        String[] array = arrayStr.split(",");
        List<Long> list = new ArrayList<>();
        for (String s : array) {
            list.add(Long.valueOf(s));
        }
        return list;
    }

    /**
     * list转成String.<br>
     * 分隔符为","
     * 
     * @param list the list
     * @return the string by list
     */
    public static String getStringByList(List<String> list) {
        if (!CollectionUtils.isEmpty(list)) {
            StringBuilder builder = new StringBuilder();
            for (String str : list) {
                builder.append(str);
                builder.append(",");
            }

            return builder.substring(0, builder.length() - 1);
        }
        return StringUtils.EMPTY;
    }

    /**
     * string 转成List<String>.<br>
     * 分隔符为","
     * 
     * @param arrayStr the array str
     * @return the string list by str
     */
    public static List<String> getStringListByStr(String arrayStr) {

        if (!StringUtils.isBlank(arrayStr)) {
            List<String> list = new ArrayList<>();
            String[] array = arrayStr.split(",");
            for (String s : array) {
                list.add(s);
            }
            return list;
        } else {
            return Collections.emptyList();
        }

    }

    /**
     * 计算比率(divisor/dividend).<br>
     * 保留2为小数<br>
     *
     * @param divisor 分子
     * @param dividend 分母
     * @return the long
     */
    public static Float calculateRatio(Long divisor, Long dividend) {
        Float result = null;
        if (dividend != null && dividend.longValue() != 0 && divisor != null) {
            BigDecimal bigDecimal = BigDecimal.valueOf(divisor).divide(BigDecimal.valueOf(dividend), 4,
                                                                       BigDecimal.ROUND_HALF_UP);
            return bigDecimal.floatValue();
        }
        return result;
    }

    /**
     * 
     * extendHundred:(浮点数乘以100，用来供前端展示%(divisor/dividend)). <br/>
     *
     * @author ZFZ
     * @param number
     * @return 保留2为小数
     * @since JDK 1.6
     */
    public static Float extendHundred(Float number) {
        if (number == null) {
            return null;
        }
        return BigDecimal.valueOf(number).multiply(BigDecimal.valueOf(100)).setScale(2, BigDecimal.ROUND_HALF_UP).floatValue();
    }
    
    /**
     * 
     * calculateFenToYuan:(分转元). <br/>
     *
     * @param yuan
     * @return
     * @since JDK 1.6
     */
    public static Double calculateFenToYuan(Long yuan){
        if (yuan == null) {
            return 0d;
        }
        return BigDecimal.valueOf(yuan).divide(BigDecimal.valueOf(100)).setScale(2, BigDecimal.ROUND_HALF_UP).doubleValue();
    }
    
}