/**
 * 
 */
package cn.com.duiba.tuia.media.common.tool;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import java.util.UUID;

import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.common.utils.Base58;

/**
 * @author Sunjiangrong
 */
public class IDGeneratorTool {

    private IDGeneratorTool idt;

    public IDGeneratorTool getIDGeneratorTool() {
        if (idt == null) {
            idt = new IDGeneratorTool();
        }
        return idt;
    }

    static String generate() throws NoSuchAlgorithmException, UnsupportedEncodingException, TuiaMediaException {
        MessageDigest md = MessageDigest.getInstance("SHA");
        md.update(UUID.randomUUID().toString().getBytes("UTF-8"));
        return Base58.encode(md.digest());
    }

    /**
     * 
     * getRandomString:(这里用一句话描述这个方法的作用). <br/>
     *
     * @author ZFZ
     * @param length
     * @return
     * @since JDK 1.6
     */
    public static String getRandomString(int length) {
        // length表示生成字符串的长度
        String base = "abcdefghijklmnopqrstuvwxyz0123456789";
        Random random = new Random();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; i++) {
            int number = random.nextInt(base.length());
            sb.append(base.charAt(number));
        }
        return sb.toString();
    }

    /**
     * 生成随机特定位的数字.
     *
     * @param length 位数
     * @return the random int
     */
    public static String getRandomInt(int length) {
        return String.valueOf((int) ((Math.random() * 9 + 1) * Math.pow(10, length - 1.0)));
    }
}