/*
 * Copyright 2014 Mopote.com The Project licenses this file to you under the Apache License, version 2.0 (the
 * "License"); you may not use this file except in compliance with the License. You may obtain a copy of the License at:
 * http://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language governing permissions and limitations under the
 * License.
 */
package cn.com.duiba.tuia.media.common.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * @since 1.0
 * @author Allen
 */
public final class SignatureArithmeticUtils {

    private SignatureArithmeticUtils() {
    }

    /**
     * 
     * get:(这里用一句话描述这个方法的作用). <br/>
     *
     * @author ZFZ
     * @param params
     * @return
     * @since JDK 1.6
     */
    public static String get(String... params) {
        List<String> srcList = new ArrayList<>();
        for (String param : params) {
            srcList.add(param);
        }
        // 按照字典序逆序拼接参数
        Arrays.sort(params);
        Collections.sort(srcList, String.CASE_INSENSITIVE_ORDER);
        Collections.reverse(srcList);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < srcList.size(); i++) {
            sb.append(srcList.get(i));
        }
        return sb.toString();
    }
}
